/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.condition.ConditionComponent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class ElevationCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    public String getKey() {
        return "elevation";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String type = this.settings.getString(TYPE).toLowerCase();
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 255.0);
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            double value = type.equals("difference") ? target.getLocation().getY() - caster.getLocation().getY() : target.getLocation().getY();
            if (!(value >= min) || !(value <= max)) continue;
            list.add(target);
        }
        return list.size() > 0 && this.executeChildren(caster, level, list, force);
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        String type = this.settings.getString(TYPE);
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 255.0);
        double value = type.equalsIgnoreCase("difference") ? target.getLocation().getY() - caster.getLocation().getY() : target.getLocation().getY();
        return value >= min && value <= max;
    }
}

