/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ManaCost;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.dynamic.ComponentRegistry;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.dynamic.trigger.Trigger;
import com.sucy.skill.dynamic.trigger.TriggerComponent;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TriggerHandler
implements Listener {
    private final HashMap<Integer, Integer> active = new HashMap();
    private final DynamicSkill skill;
    private final String key;
    private final Trigger<?> trigger;
    private final TriggerComponent component;

    public TriggerHandler(DynamicSkill skill, String key, Trigger trigger, TriggerComponent component) {
        Objects.requireNonNull(skill, "Must provide a skill");
        Objects.requireNonNull(key, "Must provide a key");
        Objects.requireNonNull(trigger, "Must provide a trigger");
        Objects.requireNonNull(component, "Must provide a component");
        this.skill = skill;
        this.key = key;
        this.trigger = trigger;
        this.component = component;
    }

    public String getKey() {
        return this.key;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public EffectComponent getComponent() {
        return this.component;
    }

    public void init(LivingEntity entity, int level) {
        this.active.put(entity.getEntityId(), level);
    }

    public void cleanup(LivingEntity entity) {
        this.active.remove(entity.getEntityId());
        this.component.cleanUp(entity);
    }

    public void register(SkillAPI plugin) {
        if (this.trigger.getEvent().getTypeName().equals("org.bukkit.event.player.PlayerInteractEvent") || this.trigger.getEvent().getTypeName().contains("PlayerSwapHandItemsEvent")) {
            plugin.getServer().getPluginManager().registerEvent(this.trigger.getEvent(), (Listener)this, EventPriority.HIGHEST, ComponentRegistry.getExecutor(this.trigger), (Plugin)plugin, false);
        } else {
            plugin.getServer().getPluginManager().registerEvent(this.trigger.getEvent(), (Listener)this, EventPriority.HIGHEST, ComponentRegistry.getExecutor(this.trigger), (Plugin)plugin, true);
        }
    }

    <T extends Event> void apply(T event, Trigger<T> trigger) {
        LivingEntity caster = trigger.getCaster(event);
        if (caster == null || !this.active.containsKey(caster.getEntityId())) {
            return;
        }
        int level = this.active.get(caster.getEntityId());
        if (!trigger.shouldTrigger(event, level, this.component.settings)) {
            return;
        }
        LivingEntity target = trigger.getTarget(event, this.component.settings);
        trigger.setValues(event, DynamicSkill.getCastData(caster));
        this.trigger(caster, target, level);
        if (event instanceof Cancellable) {
            this.skill.applyCancelled((Cancellable)event);
        }
        trigger.postProcess(event, this.skill);
    }

    boolean trigger(LivingEntity user, LivingEntity target, int level) {
        if (user == null || target == null || this.component.isRunning() || !SkillAPI.getSettings().isValidTarget(target)) {
            return false;
        }
        if (user instanceof Player) {
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)user));
            PlayerSkill skill = data.getSkill(this.skill.getName());
            boolean cd = this.component.getSettings().getBool("cooldown", false);
            boolean mana = this.component.getSettings().getBool("mana", false);
            if ((cd || mana) && !data.check(skill, cd, mana)) {
                return false;
            }
            if (this.component.trigger(user, target, level, false)) {
                if (cd) {
                    skill.startCooldown();
                }
                if (mana) {
                    data.useMana(skill.getManaCost(), ManaCost.SKILL_CAST);
                }
                return true;
            }
            return false;
        }
        return this.component.trigger(user, target, level, false);
    }
}

