/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic;

import com.sucy.skill.api.Settings;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.EffectComponent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.promcteam.engine.mccore.config.parse.NumberParser;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemChecker {
    private static final String CHECK_MAT = "check-mat";
    private static final String MATERIAL = "material";
    private static final String CHECK_DATA = "check-data";
    private static final String DATA = "data";
    private static final String CHECK_LORE = "check-lore";
    private static final String LORE = "lore";
    private static final String REGEX = "regex";
    private static final String CHECK_NAME = "check-name";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";

    public static boolean check(Player player, int level, EffectComponent component, boolean remove) {
        Settings settings = component.getSettings();
        int count = (int)component.parseValues((LivingEntity)player, AMOUNT, level, 1.0);
        boolean mat = settings.getBool(CHECK_MAT, true);
        boolean data = settings.getBool(CHECK_DATA, true);
        boolean lore = settings.getBool(CHECK_LORE, false);
        boolean name = settings.getBool(CHECK_NAME, false);
        boolean regex = settings.getBool(REGEX, false);
        String material = settings.getString(MATERIAL, "ARROW").toUpperCase().replace(" ", "_");
        int dur = settings.getInt(DATA, 0);
        String text = settings.getString(LORE, "");
        String display = settings.getString(NAME, "");
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || mat && !item.getType().name().equals(material) || data && item.getData().getData() != dur || lore && !ItemChecker.checkLore(item, text, regex) || name && !ItemChecker.checkName(item, display, regex)) continue;
            if (item.getAmount() <= count) {
                count -= item.getAmount();
                if (remove) {
                    contents[i] = null;
                }
            } else {
                if (remove) {
                    item.setAmount(item.getAmount() - count);
                }
                count = 0;
            }
            if (count == 0) break;
        }
        if (remove) {
            player.getInventory().setContents(contents);
        }
        return count == 0;
    }

    public static boolean check(ItemStack item, int level, Settings settings) {
        boolean mat = settings.getBool(CHECK_MAT, true);
        boolean data = settings.getBool(CHECK_DATA, true);
        boolean lore = settings.getBool(CHECK_LORE, false);
        boolean name = settings.getBool(CHECK_NAME, false);
        boolean regex = settings.getBool(REGEX, false);
        String material = settings.getString(MATERIAL, "ARROW").toUpperCase().replace(" ", "_");
        int dur = settings.getInt(DATA, 0);
        String text = settings.getString(LORE, "");
        String display = settings.getString(NAME, "");
        return !(item == null || mat && !item.getType().name().equals(material) || data && item.getDurability() != dur || lore && !ItemChecker.checkLore(item, text, regex) || name && !ItemChecker.checkName(item, display, regex));
    }

    public static boolean checkName(ItemStack item, String target, boolean regex) {
        ItemMeta meta;
        if (!item.hasItemMeta() || !(meta = item.getItemMeta()).hasDisplayName()) {
            return false;
        }
        String name = ChatColor.stripColor((String)meta.getDisplayName());
        if (regex && Pattern.compile(target).matcher(name).find()) {
            return true;
        }
        return !regex && name.contains(target);
    }

    public static boolean checkLore(ItemStack item, String target, boolean regex) {
        ItemMeta meta;
        if (!item.hasItemMeta() || !(meta = item.getItemMeta()).hasLore()) {
            return false;
        }
        List lore = meta.getLore();
        for (String line : lore) {
            line = ChatColor.stripColor((String)line);
            if (regex && Pattern.compile(target).matcher(line).find()) {
                return true;
            }
            if (regex || !line.contains(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean findLore(LivingEntity caster, ItemStack item, String regex, String key, double multiplier) {
        Pattern pattern = Pattern.compile(regex.replace("{value}", "([+-]?[0-9]+([.,][0-9]+)?)"));
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return false;
        }
        List lore = item.getItemMeta().getLore();
        for (String line : lore) {
            Matcher matcher = pattern.matcher(line = ChatColor.stripColor((String)line));
            if (!matcher.find()) continue;
            String value = matcher.group(1);
            try {
                double base = NumberParser.parseDouble((String)value);
                DynamicSkill.getCastData(caster).put(key, base * multiplier);
                break;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }
}

