/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data.formula;

import com.sucy.skill.data.formula.IOperator;
import com.sucy.skill.data.formula.IValue;
import com.sucy.skill.data.formula.func.Abs;
import com.sucy.skill.data.formula.func.Ceil;
import com.sucy.skill.data.formula.func.Cos;
import com.sucy.skill.data.formula.func.Floor;
import com.sucy.skill.data.formula.func.Root;
import com.sucy.skill.data.formula.func.Sign;
import com.sucy.skill.data.formula.func.Sin;
import com.sucy.skill.data.formula.func.Square;
import com.sucy.skill.data.formula.func.Tan;
import com.sucy.skill.data.formula.operator.Addition;
import com.sucy.skill.data.formula.operator.Division;
import com.sucy.skill.data.formula.operator.Exponent;
import com.sucy.skill.data.formula.operator.Log;
import com.sucy.skill.data.formula.operator.Modulo;
import com.sucy.skill.data.formula.operator.Multiplication;
import com.sucy.skill.data.formula.operator.Subtraction;
import com.sucy.skill.data.formula.value.CustomValue;
import com.sucy.skill.data.formula.value.ValueNum;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class Formula
implements IValue {
    public static final double DEG_TO_RAD = Math.PI / 180;
    private static final HashMap<Character, IOperator> OPS = new HashMap<Character, IOperator>(){
        {
            this.put(Character.valueOf('+'), new Addition());
            this.put(Character.valueOf('-'), new Subtraction());
            this.put(Character.valueOf('*'), new Multiplication());
            this.put(Character.valueOf('/'), new Division());
            this.put(Character.valueOf('%'), new Modulo());
            this.put(Character.valueOf('^'), new Exponent());
            this.put(Character.valueOf('_'), new Log());
        }
    };
    private static final HashMap<String, Class<? extends IValue>> FUNCS = new HashMap<String, Class<? extends IValue>>(){
        {
            this.put("abs", Abs.class);
            this.put("ceil", Ceil.class);
            this.put("cos", Cos.class);
            this.put("floor", Floor.class);
            this.put("sqrt", Root.class);
            this.put("sign", Sign.class);
            this.put("sin", Sin.class);
            this.put("sq", Square.class);
            this.put("tan", Tan.class);
        }
    };
    private IValue[] values;
    private IOperator[] operations;
    private boolean valid;
    private boolean negative;
    private String equation;

    public Formula(String equation, CustomValue ... defined) {
        int i = 0;
        for (CustomValue value : defined) {
            value.setIndex(i++);
        }
        this.negative = false;
        if (equation == null || equation.length() == 0) {
            this.invalidate(defined);
            return;
        }
        this.equation = equation = equation.replaceAll("[ '\"]", "");
        ArrayList<IValue> vals = new ArrayList<IValue>();
        ArrayList<IOperator> ops = new ArrayList<IOperator>();
        int parens = 0;
        int l = equation.length();
        int valStart = 0;
        int lastOp = -1;
        Class<? extends IValue> func = null;
        for (i = 0; i < l; ++i) {
            char c = equation.charAt(i);
            if (c == '(') {
                if (parens == 0) {
                    if (valStart != i) {
                        String val = equation.substring(valStart, i);
                        if (FUNCS.containsKey(val)) {
                            func = FUNCS.get(val);
                        } else {
                            vals.add(this.makeVal(val, defined));
                            ops.add(OPS.get(Character.valueOf('*')));
                        }
                    }
                    valStart = i + 1;
                    lastOp = i;
                }
                ++parens;
                continue;
            }
            if (c == ')') {
                if (--parens != 0) continue;
                if (func == null) {
                    vals.add(this.makeVal(new Formula(equation.substring(valStart, i), defined)));
                } else {
                    try {
                        vals.add((IValue)func.getConstructor(IValue.class).newInstance(this.makeVal(new Formula(equation.substring(valStart, i), defined))));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.invalidate(defined);
                        return;
                    }
                }
                valStart = i + 1;
                continue;
            }
            if (parens != 0 || !OPS.containsKey(Character.valueOf(c))) continue;
            if (c == '-' && lastOp == i - 1) {
                this.negative = !this.negative;
                ++valStart;
                ++lastOp;
                continue;
            }
            if (valStart != i) {
                vals.add(this.makeVal(equation.substring(valStart, i), defined));
            }
            ops.add(OPS.get(Character.valueOf(c)));
            lastOp = i;
            valStart = i + 1;
        }
        if (valStart != l) {
            vals.add(this.makeVal(equation.substring(valStart), defined));
        }
        this.negative = false;
        this.values = vals.toArray(new IValue[vals.size()]);
        this.operations = ops.toArray(new IOperator[ops.size()]);
        if (!this.validate()) {
            this.invalidate(defined);
        } else {
            this.valid = true;
        }
    }

    private void invalidate(CustomValue ... defined) {
        Logger.invalid("Invalid equation: " + this.equation);
        this.equation = defined[0].getToken();
        this.values = new IValue[]{defined[0]};
        this.operations = new IOperator[0];
        this.valid = false;
    }

    private IValue makeVal(String val, CustomValue ... defined) {
        if (this.negative) {
            this.negative = false;
            return new Formula(val, defined).negate();
        }
        for (CustomValue value : defined) {
            if (!value.getToken().equals(val)) continue;
            return value;
        }
        return new ValueNum(val);
    }

    private IValue makeVal(Formula val) {
        if (this.negative && val.operations.length == 0 && val.values[0] instanceof ValueNum) {
            return new ValueNum(-val.values[0].compute(new double[0]));
        }
        if (this.negative) {
            val.negate();
            this.negative = false;
            return val;
        }
        if (val.operations.length == 0) {
            return val.values[0];
        }
        return val;
    }

    public Formula negate() {
        this.negative = !this.negative;
        return this;
    }

    private boolean validate() {
        if (this.values.length != this.operations.length + 1) {
            return false;
        }
        for (IValue value : this.values) {
            if (!(value instanceof Formula) || ((Formula)value).validate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double compute(double ... input) {
        double result = this.values[0].compute(input);
        for (int i = 1; i < this.values.length; ++i) {
            double val = this.values[i].compute(input);
            result = this.operations[i - 1].compute(result, val);
        }
        if (this.negative) {
            result = -result;
        }
        return result;
    }

    public String toString() {
        return this.equation;
    }

    public boolean isValid() {
        return this.valid;
    }
}

