/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.FilterType;
import mc.promcteam.engine.mccore.scoreboard.StatHolder;

public class PlayerStats
implements StatHolder {
    private static final String BASE = "Stats.";
    private static final String EXP = "exp";
    private static final String HEALTH = "health";
    private static final String LEVEL = "level";
    private static final String POINTS = "points";
    private static final String ATTRIB = "attrib";
    private static final HashMap<String, String> statMap = new HashMap();
    private final PlayerClass player;

    public PlayerStats(PlayerClass player) {
        this.player = player;
    }

    public static void init() {
        if (statMap.size() == 0) {
            PlayerStats.load(EXP, "Stats.exp");
            PlayerStats.load(HEALTH, "Stats.health");
            PlayerStats.load(LEVEL, "Stats.level");
            PlayerStats.load(POINTS, "Stats.points");
            PlayerStats.load(ATTRIB, "Stats.attrib");
        }
    }

    public static void clear() {
        statMap.clear();
    }

    private static void load(String key, String node) {
        statMap.put(key, (String)SkillAPI.getLanguage().getMessage(node, true, FilterType.COLOR, new CustomFilter[0]).get(0));
    }

    public List<String> getNames() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add(statMap.get(HEALTH));
        if (SkillAPI.getSettings().isManaEnabled()) {
            stats.add(this.player.getData().getManaName());
        }
        stats.add(statMap.get(POINTS));
        stats.add(statMap.get(LEVEL));
        stats.add(statMap.get(EXP));
        if (SkillAPI.getSettings().isAttributesEnabled()) {
            stats.add(statMap.get(ATTRIB));
        }
        return stats;
    }

    public ArrayList<Integer> getValues() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add((int)Math.ceil(this.player.getPlayerData().getPlayer().getHealth()));
        if (SkillAPI.getSettings().isManaEnabled()) {
            values.add((int)this.player.getPlayerData().getMana());
        }
        values.add(this.player.getPoints());
        values.add(this.player.getLevel());
        values.add((int)this.player.getExp());
        if (SkillAPI.getSettings().isAttributesEnabled()) {
            values.add(this.player.getPlayerData().getAttributePoints());
        }
        return values;
    }
}

