/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data;

import com.google.common.collect.ImmutableList;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.List;
import mc.promcteam.engine.mccore.config.parse.DataSection;

public class GroupSettings {
    private static final int[] POINTS = new int[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1};
    private static final String PROFESS_RESET = "profess-reset";
    private static final String PROFESS_REFUND_SKILLS = "profess-refund-skills";
    private static final String PROFESS_REFUND_ATTRIBUTES = "profess-refund-attributes";
    private static final String CAN_RESET = "can-reset";
    private static final String EXP_LOST = "exp-lost-on-death";
    private static final String STARTING_POINTS = "starting-points";
    private static final String POINTS_PER_LEVEL = "points-per-level";
    private static final String PERMISSION = "permission";
    private static final String FRIENDLY = "friendly";
    private static final String DEFAULT = "default";
    private static final String STARTING_ATTRIBS = "starting-attribs";
    private static final String ATTRIB_PER_LEVEL = "attribs-per-level";
    private static final String SCOREBOARD = "show-scoreboard";
    private static final String CUSTOM_POINTS = "use-custom-points";
    private static final String DEFINED_POINTS = "custom-points";
    private static final String CUSTOM_ATTRIBS = "use-custom-attribute-points";
    private static final String DEFINED_ATTRIBS = "custom-attribute-points";
    private String defaultClass = "none";
    private String permission = "none";
    private boolean professReset = false;
    private boolean professRefundSkills = false;
    private boolean professRefundAttributes = false;
    private boolean showScoreboard = true;
    private boolean canReset = true;
    private boolean friendly = false;
    private boolean useCustomPoints = false;
    private boolean useCustomAttribs = false;
    private int[] customPoints = POINTS;
    private int[] customAttribs = POINTS;
    private double deathPenalty = 0.0;
    private int startingPoints = 1;
    private double pointsPerLevel = 1.0;
    private double attribsPerLevel = 1.0;
    private int startingAttribs = 0;

    public GroupSettings() {
    }

    public GroupSettings(DataSection config) {
        this.defaultClass = config.getString(DEFAULT, this.defaultClass);
        this.permission = config.getString(PERMISSION, this.permission);
        this.professReset = config.getBoolean(PROFESS_RESET, this.professReset);
        this.professRefundAttributes = config.getBoolean(PROFESS_REFUND_ATTRIBUTES, this.professRefundAttributes);
        this.professRefundSkills = config.getBoolean(PROFESS_REFUND_SKILLS, this.professRefundSkills);
        this.showScoreboard = config.getBoolean(SCOREBOARD, this.showScoreboard);
        this.canReset = config.getBoolean(CAN_RESET, this.canReset);
        this.friendly = config.getBoolean(FRIENDLY, this.friendly);
        this.deathPenalty = config.getDouble(EXP_LOST, this.deathPenalty);
        this.startingPoints = config.getInt(STARTING_POINTS, this.startingPoints);
        this.pointsPerLevel = config.getDouble(POINTS_PER_LEVEL, this.pointsPerLevel);
        this.attribsPerLevel = config.getDouble(ATTRIB_PER_LEVEL, this.attribsPerLevel);
        this.startingAttribs = config.getInt(STARTING_ATTRIBS, this.startingAttribs);
        this.useCustomPoints = config.getBoolean(CUSTOM_POINTS, false);
        this.useCustomAttribs = config.getBoolean(CUSTOM_ATTRIBS, false);
        this.customPoints = this.loadCustomPoints(config.getSection(DEFINED_POINTS));
        this.customAttribs = this.loadCustomPoints(config.getSection(DEFINED_ATTRIBS));
        this.save(config);
    }

    private int[] loadCustomPoints(DataSection data) {
        if (data != null) {
            ArrayList<Integer> points = new ArrayList<Integer>();
            for (String key : data.keys()) {
                try {
                    int level = Integer.parseInt(key);
                    if (level < points.size()) {
                        points.set(level, data.getInt(key, 0));
                        continue;
                    }
                    while (level > points.size()) {
                        points.add(0);
                    }
                    points.add(data.getInt(key, 0));
                }
                catch (NumberFormatException ex) {
                    Logger.invalid(key + " is not a valid level for custom skill points");
                }
            }
            return points.stream().mapToInt(Integer::intValue).toArray();
        }
        return POINTS;
    }

    public RPGClass getDefault() {
        return SkillAPI.getClass(this.defaultClass);
    }

    public boolean requiresPermission() {
        return !this.permission.equals("none");
    }

    public String getPermission() {
        return this.requiresPermission() ? this.permission : null;
    }

    public int getPointsForLevels(int newLevel, int oldLevel) {
        return this.computePoints(newLevel, oldLevel, this.useCustomPoints, this.customPoints, this.pointsPerLevel);
    }

    public int getAttribsForLevels(int newLevel, int oldLevel) {
        return this.computePoints(newLevel, oldLevel, this.useCustomAttribs, this.customAttribs, this.attribsPerLevel);
    }

    private int computePoints(int newLevel, int oldLevel, boolean custom, int[] data, double perLevel) {
        if (custom) {
            int newPoints = 0;
            for (int i = 1; i < data.length && i <= newLevel; ++i) {
                newPoints += data[i];
            }
            int oldPoints = 0;
            for (int i = 1; i < data.length && i <= oldLevel; ++i) {
                oldPoints += data[i];
            }
            return newPoints - oldPoints;
        }
        return (int)((double)newLevel * perLevel) - (int)((double)oldLevel * perLevel);
    }

    public void save(DataSection config) {
        config.setComments(DEFAULT, (List)ImmutableList.of((Object)"", (Object)" The starting class for all players for this group.", (Object)" \"none\" will result in no starting class"));
        config.set(DEFAULT, (Object)this.defaultClass);
        config.setComments(PERMISSION, (List)ImmutableList.of((Object)"", (Object)" The permission required to profess as any class in this group.", (Object)" \"none\" will result in no permissions being required"));
        config.set(PERMISSION, (Object)this.permission);
        config.setComments(PROFESS_RESET, (List)ImmutableList.of((Object)"", (Object)" Whether to reset a players level and skill points to starting values", (Object)" when professing into a subclass"));
        config.set(PROFESS_RESET, (Object)this.professReset);
        config.setComments(PROFESS_REFUND_SKILLS, (List)ImmutableList.of((Object)"", (Object)" If profess-reset is true, this determines if skill points are refunded", (Object)" or just deleted"));
        config.set(PROFESS_REFUND_SKILLS, (Object)this.professRefundSkills);
        config.setComments(PROFESS_REFUND_ATTRIBUTES, (List)ImmutableList.of((Object)"", (Object)" If profess-reset is true, this determines if attribute points are refunded", (Object)" or just deleted"));
        config.set(PROFESS_REFUND_ATTRIBUTES, (Object)this.professRefundAttributes);
        config.setComments(CAN_RESET, (List)ImmutableList.of((Object)"", (Object)" Whether or not this class is reset when players use the reset command"));
        config.set(CAN_RESET, (Object)this.canReset);
        config.setComments(FRIENDLY, (List)ImmutableList.of((Object)"", (Object)" Whether or not players professed as the same base class in this group", (Object)" are considered allies and cannot attack each other"));
        config.set(FRIENDLY, (Object)this.friendly);
        config.setComments(SCOREBOARD, (List)ImmutableList.of((Object)"", (Object)" Whether or not to show a scoreboard for classes within this group.", (Object)" Scoreboards must be enabled for this to work."));
        config.set(SCOREBOARD, (Object)this.showScoreboard);
        config.setComments(EXP_LOST, (List)ImmutableList.of((Object)"", (Object)" Percentage of experience lost upon dying.", (Object)" This will not cause players to lose levels."));
        config.set(EXP_LOST, (Object)this.deathPenalty);
        config.setComments(STARTING_POINTS, (List)ImmutableList.of((Object)"", (Object)" Number of skill points players start with"));
        config.set(STARTING_POINTS, (Object)this.startingPoints);
        config.setComments(POINTS_PER_LEVEL, (List)ImmutableList.of((Object)"", (Object)" How many skill points a player gains every level.", (Object)" You can use decimal values for one point every few levels.", (Object)" 0.2, for instance, would give one point every 5 levels.", (Object)" If use-custom-points is enabled, this is ignored"));
        config.set(POINTS_PER_LEVEL, (Object)this.pointsPerLevel);
        config.setComments(STARTING_ATTRIBS, (List)ImmutableList.of((Object)"", (Object)" Number of attribute points players start with"));
        config.set(STARTING_ATTRIBS, (Object)this.startingAttribs);
        config.setComments(ATTRIB_PER_LEVEL, (List)ImmutableList.of((Object)"", (Object)" How many attribute points a player gains every level.", (Object)" You can use decimal values for one point every few levels.", (Object)" 0.2, for instance, would give one point every 5 levels.", (Object)" If use-custom-attribute-points is enabled, this is ignored."));
        config.set(ATTRIB_PER_LEVEL, (Object)this.attribsPerLevel);
        config.setComments(CUSTOM_POINTS, (List)ImmutableList.of((Object)"", (Object)" Whether or not to use custom skill point distribution.", (Object)" When enabled, skill points are given based on custom-points", (Object)" instead of points-per-level"));
        config.set(CUSTOM_POINTS, (Object)this.useCustomPoints);
        config.setComments(CUSTOM_ATTRIBS, (List)ImmutableList.of((Object)"", (Object)" Whether or not to use custom attribute point distribution.", (Object)" When enabled, attribute points are given based on custom-attribute-points", (Object)" instead of attribs-per-level"));
        config.set(CUSTOM_ATTRIBS, (Object)this.useCustomAttribs);
        config.setComments(DEFINED_POINTS, (List)ImmutableList.of((Object)"", (Object)" Defines how many skill points players get at specific levels.", (Object)" This only applies when use-custom-points is set to \"true\".", (Object)" Numbers on the left are the level the skill points are given.", (Object)" Numbers on the right are how many skill points are given."));
        this.savePoints(config.createSection(DEFINED_POINTS), this.customPoints);
        config.setComments(DEFINED_ATTRIBS, (List)ImmutableList.of((Object)"", (Object)" Defines how many attribute points players get at specific levels.", (Object)" This only applies when use-custom-attribute-points is set to \"true\".", (Object)" Numbers on the left are the level the attribute points are given.", (Object)" Numbers on the right are how many attribute points are given."));
        this.savePoints(config.createSection(DEFINED_ATTRIBS), this.customAttribs);
    }

    private void savePoints(DataSection destination, int[] points) {
        for (int i = 0; i < points.length; ++i) {
            if (points[i] <= 0) continue;
            destination.set(Integer.toString(i), (Object)points[i]);
        }
    }

    public boolean isProfessReset() {
        return this.professReset;
    }

    public boolean isProfessRefundSkills() {
        return this.professRefundSkills;
    }

    public boolean isProfessRefundAttributes() {
        return this.professRefundAttributes;
    }

    public boolean isShowScoreboard() {
        return this.showScoreboard;
    }

    public boolean canReset() {
        return this.canReset;
    }

    public boolean isFriendly() {
        return this.friendly;
    }

    public double getDeathPenalty() {
        return this.deathPenalty;
    }

    public int getStartingPoints() {
        return this.startingPoints;
    }

    public double getPointsPerLevel() {
        return this.pointsPerLevel;
    }

    public double getAttribsPerLevel() {
        return this.attribsPerLevel;
    }

    public int getStartingAttribs() {
        return this.startingAttribs;
    }
}

