/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerAccounts;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import java.util.Map;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdSwitch
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_CLASS = "not-class";
    private static final String CHANGED = "account-changed";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", new CustomFilter[0]);
        } else if (!SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (args.length == 0) {
            command.displayHelp(sender);
        } else {
            PlayerAccounts player = SkillAPI.getPlayerAccountData((OfflinePlayer)((Player)sender));
            RPGClass rpgClass = this.getRoot(SkillAPI.getClass(args[0]));
            if (rpgClass != null) {
                boolean done = false;
                for (Map.Entry<Integer, PlayerData> entry : player.getAllData().entrySet()) {
                    PlayerClass accountClass = entry.getValue().getMainClass();
                    if (accountClass == null || this.getRoot(accountClass.getData()) != rpgClass) continue;
                    player.setAccount(entry.getKey());
                    done = true;
                    break;
                }
                if (!done) {
                    int i = 1;
                    if (player.getActiveData().getMainClass() != null) {
                        while (player.getData(i) != null) {
                            ++i;
                        }
                    }
                    player.setAccount(i);
                    player.getActiveData().profess(rpgClass);
                }
                command.sendMessage(sender, CHANGED, ChatColor.DARK_GREEN + "You have changed classes", new CustomFilter[0]);
                return;
            }
            command.sendMessage(sender, NOT_CLASS, ChatColor.RED + "That is not a valid class", new CustomFilter[0]);
        }
    }

    private RPGClass getRoot(RPGClass rpgClass) {
        if (rpgClass == null) {
            return null;
        }
        while (rpgClass.getParent() != null) {
            rpgClass = rpgClass.getParent();
        }
        return rpgClass;
    }
}

