/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CmdForceSkill
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_SKILL = "not-skill";
    private static final String NOT_FUNCTION = "not-function";
    private static final String UPGRADED = "skill-upped";
    private static final String DOWNGRADED = "skill-downed";
    private static final String RESET = "skill-reset";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (args.length < 3) {
            command.displayHelp(sender);
        } else {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
            if (player == null) {
                command.sendMessage(sender, NOT_PLAYER, "&4That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerData playerData = SkillAPI.getPlayerData(player);
            StringBuilder skillName = new StringBuilder(args[2]);
            for (int i = 3; i < args.length; ++i) {
                skillName.append(" " + args[i]);
            }
            PlayerSkill skill = playerData.getSkill(skillName.toString());
            if (skill == null) {
                command.sendMessage(sender, NOT_SKILL, "&4The player does not have access to that skill", new CustomFilter[0]);
                return;
            }
            if (args[1].equals("up")) {
                playerData.forceUpSkill(skill);
                command.sendMessage(sender, UPGRADED, "&6" + skill.getData().getName() + "&2 was upgraded for &6" + player.getName(), new CustomFilter[0]);
            } else if (args[1].equals("down")) {
                playerData.forceDownSkill(skill);
                command.sendMessage(sender, DOWNGRADED, "&6" + skill.getData().getName() + "&2 was downgraded for &6" + player.getName(), new CustomFilter[0]);
            } else if (args[1].equals("reset")) {
                playerData.refundSkill(skill);
                command.sendMessage(sender, RESET, "&6" + skill.getData().getName() + "&2 was reset for &6" + player.getName(), new CustomFilter[0]);
            } else {
                command.sendMessage(sender, NOT_FUNCTION, "&4That is not a valid function. Use up, down, or reset.", new CustomFilter[0]);
            }
        }
    }
}

