/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkillBar;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdBar
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NO_CLASS = "no-class";
    private static final String IN_CREATIVE = "in-creative";
    private static final String NO_SPACE = "no-space";
    private static final String TOGGLE_ON = "toggle-on";
    private static final String TOGGLE_OFF = "toggle-off";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", new CustomFilter[0]);
            return;
        }
        if (!SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
            return;
        }
        PlayerData player = SkillAPI.getPlayerData((OfflinePlayer)((Player)sender));
        if (!player.hasClass()) {
            command.sendMessage(sender, NO_CLASS, "&4You have not professed as any class yet", new CustomFilter[0]);
        } else if (player.getPlayer().getGameMode() == GameMode.CREATIVE) {
            command.sendMessage(sender, IN_CREATIVE, "&4You cannot be in creative mode", new CustomFilter[0]);
        } else {
            PlayerSkillBar bar = player.getSkillBar();
            if (!bar.isEnabled() && bar.countOpenSlots() < bar.getItemsInSkillSlots()) {
                command.sendMessage(sender, NO_SPACE, "&4You don't have enough inventory space for the skill bar", new CustomFilter[0]);
                return;
            }
            bar.toggleEnabled();
            if (bar.isEnabled()) {
                command.sendMessage(sender, TOGGLE_ON, "&2Your skill bar has been &6enabled", new CustomFilter[0]);
            } else {
                command.sendMessage(sender, TOGGLE_OFF, "&2Your skill bar has been &2disabled", new CustomFilter[0]);
            }
        }
    }
}

