/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.cast.PlayerView;
import com.sucy.skill.task.PreviewTask;
import com.sucy.skill.thread.MainThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerCastBars
implements InventoryHolder {
    private HashMap<Integer, String> hoverBar = new HashMap();
    private HashMap<Integer, String> instantBar = new HashMap();
    private HashSet<String> used = new HashSet();
    private HashSet<String> unused = new HashSet();
    private PlayerView view = PlayerView.INVENTORY;
    private ItemStack[] backup;
    private PlayerData player;
    private PlayerSkill hovered;
    private long cooldown;
    private int oldSlot;

    public PlayerCastBars(PlayerData data) {
        this.player = data;
    }

    public void validate() {
        this.validate(this.hoverBar);
        this.validate(this.instantBar);
    }

    public boolean isHovering() {
        return this.view == PlayerView.HOVER_BAR;
    }

    public PlayerView getView() {
        return this.view;
    }

    private void hoverSkill(Player player, int slot) {
        this.hovered = this.hoverBar.containsKey(slot) ? this.player.getSkill(this.hoverBar.get(slot)) : null;
    }

    public void playHoverParticles(Player player, int step) {
        if (this.hovered == null) {
            return;
        }
        this.hovered.playParticles(player, step);
    }

    private void validate(HashMap<Integer, String> map) {
        Iterator<Map.Entry<Integer, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, String> entry = iterator.next();
            if (this.player.hasSkill(entry.getValue()) && this.player.getSkill(entry.getValue()).isUnlocked()) continue;
            iterator.remove();
            this.used.remove(entry.getValue());
        }
    }

    public void restore(Player player) {
        if (this.view == PlayerView.INVENTORY) {
            return;
        }
        if (this.view == PlayerView.ORGANIZER) {
            this.reset();
            ItemStack[] contents = player.getInventory().getContents();
            this.update(contents, this.hoverBar, 0);
            this.update(contents, this.instantBar, 24);
        }
        player.getInventory().setContents(this.backup);
        this.view = PlayerView.INVENTORY;
        player.getInventory().setHeldItemSlot(this.oldSlot);
    }

    public boolean showOrganizer(final Player player) {
        if (this.used.size() + this.unused.size() == 0 || this.view != PlayerView.INVENTORY) {
            return false;
        }
        this.view = PlayerView.ORGANIZER;
        this.backup = player.getInventory().getContents();
        ItemStack[] playerContents = new ItemStack[36];
        playerContents[8] = SkillAPI.getSettings().getHoverItem();
        playerContents[35] = SkillAPI.getSettings().getInstantItem();
        this.fill(playerContents, this.hoverBar, 0);
        this.fill(playerContents, this.instantBar, 24);
        int size = Math.min(54, 9 * ((this.used.size() + this.unused.size() + 8) / 9));
        final Inventory inv = player.getServer().createInventory((InventoryHolder)this, size);
        ItemStack[] contents = new ItemStack[size];
        int i = 0;
        int j = 9;
        for (String skill : this.unused) {
            if (i < contents.length) {
                contents[i++] = this.makeIndicator(skill);
                continue;
            }
            if (j >= 24) continue;
            playerContents[j++] = this.makeIndicator(skill);
        }
        player.getInventory().setContents(playerContents);
        inv.setContents(contents);
        new BukkitRunnable(){

            public void run() {
                player.openInventory(inv);
            }
        }.runTask((Plugin)SkillAPI.inst());
        return true;
    }

    private void fill(ItemStack[] contents, HashMap<Integer, String> bar, int index) {
        for (Map.Entry<Integer, String> entry : bar.entrySet()) {
            contents[index + entry.getKey().intValue()] = this.makeIndicator(entry.getValue());
        }
    }

    private void update(ItemStack[] contents, HashMap<Integer, String> bar, int index) {
        for (int i = 0; i < 8; ++i) {
            List lore;
            String skill;
            if (contents[i + index] == null || !this.unused.contains(skill = (String)(lore = contents[i + index].getItemMeta().getLore()).get(lore.size() - 1))) continue;
            bar.put(i, skill);
            this.used.add(skill);
            this.unused.remove(skill);
        }
    }

    private ItemStack makeIndicator(String skill) {
        if (skill == null) {
            return null;
        }
        ItemStack item = SkillAPI.getSkill(skill).getIndicator(this.player.getSkill(skill), true);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore.add(skill);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public boolean showHoverBar(Player player) {
        boolean result = this.show(player, PlayerView.HOVER_BAR, this.hoverBar);
        player.getInventory().setHeldItemSlot(0);
        this.hoverSkill(player, 0);
        MainThread.register(new PreviewTask(player));
        return result;
    }

    public boolean showInstantBar(Player player) {
        return this.show(player, PlayerView.INSTANT_BAR, this.instantBar);
    }

    private boolean show(Player player, PlayerView view, HashMap<Integer, String> bar) {
        long left = System.currentTimeMillis() - this.cooldown - SkillAPI.getSettings().getCastCooldown();
        if (this.view != PlayerView.INVENTORY || bar.size() == 0 || left < 0L) {
            return false;
        }
        this.view = view;
        this.backup = player.getInventory().getContents();
        ItemStack[] contents = new ItemStack[36];
        this.makeContents(bar, contents, 0);
        player.getInventory().setContents(contents);
        return true;
    }

    public boolean handle(PlayerItemHeldEvent event) {
        switch (this.view) {
            case INSTANT_BAR: {
                if (this.instantBar.containsKey(event.getNewSlot())) {
                    this.player.cast(this.instantBar.get(event.getNewSlot()));
                    this.cooldown = System.currentTimeMillis();
                }
                this.restore(event.getPlayer());
                event.setCancelled(true);
                return true;
            }
            case HOVER_BAR: {
                this.hoverSkill(event.getPlayer(), event.getNewSlot());
                return true;
            }
            case INVENTORY: {
                this.oldSlot = event.getPreviousSlot();
                return false;
            }
        }
        return false;
    }

    public boolean handleInteract(Player player) {
        switch (this.view) {
            case INSTANT_BAR: {
                this.restore(player);
                return true;
            }
            case HOVER_BAR: {
                if (this.hoverBar.containsKey(player.getInventory().getHeldItemSlot())) {
                    this.player.cast(this.hoverBar.get(player.getInventory().getHeldItemSlot()));
                    this.cooldown = System.currentTimeMillis();
                }
                this.restore(player);
                return true;
            }
        }
        return false;
    }

    public void handleOpen(Player player) {
        if (this.view == PlayerView.HOVER_BAR || this.view == PlayerView.INSTANT_BAR) {
            this.restore(player);
        }
    }

    public void handle(InventoryClickEvent event) {
        if (event.getInventory() == event.getWhoClicked().getInventory()) {
            if (event.getSlot() == 8 || event.getSlot() == 35) {
                event.setCancelled(true);
            }
        } else if (event.getSlot() < 0) {
            event.setCancelled(true);
        }
    }

    public void unlock(PlayerSkill skill) {
        if (!this.addTo(this.hoverBar, skill)) {
            this.addTo(this.instantBar, skill);
        }
    }

    private boolean addTo(HashMap<Integer, String> bar, PlayerSkill skill) {
        for (int i = 0; i < 9; ++i) {
            if (bar.containsKey(i)) continue;
            this.add(bar, skill.getData().getName(), i);
            return true;
        }
        return false;
    }

    private void add(HashMap<Integer, String> bar, String skill, int slot) {
        bar.put(slot, skill);
        this.used.add(skill);
        this.unused.remove(skill);
    }

    public void reset() {
        this.unused.clear();
        this.used.clear();
        this.instantBar.clear();
        this.hoverBar.clear();
        for (PlayerSkill skill : this.player.getSkills()) {
            if (!skill.isUnlocked() || !skill.getData().canCast()) continue;
            this.unused.add(skill.getData().getName());
        }
    }

    private void makeContents(HashMap<Integer, String> slots, ItemStack[] contents, int offset) {
        for (Map.Entry<Integer, String> slot : slots.entrySet()) {
            PlayerSkill skill = this.player.getSkill(slot.getValue());
            if (skill == null) continue;
            contents[offset + slot.getKey().intValue()] = skill.getData().getIndicator(skill, true);
        }
    }

    public void load(DataSection config, boolean hover) {
        if (config == null) {
            return;
        }
        HashMap<Integer, String> bar = hover ? this.hoverBar : this.instantBar;
        for (String key : config.keys()) {
            this.add(bar, key, config.getInt(key));
        }
    }

    public void save(DataSection config, boolean hover) {
        HashMap<Integer, String> bar = hover ? this.hoverBar : this.instantBar;
        for (Map.Entry<Integer, String> entry : bar.entrySet()) {
            config.set(entry.getValue(), (Object)entry.getKey());
        }
    }

    public Inventory getInventory() {
        return null;
    }
}

