/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.cast.Preview;
import com.sucy.skill.cast.PreviewSettings;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ConePreview
extends Preview {
    private double arc;
    private double radius;
    private double sin;
    private double cos;
    private double rSin;
    private double rCos;
    private double offset;
    private double angleOffset;

    public ConePreview(double arc, double radius) {
        if (radius == 0.0) {
            throw new IllegalArgumentException("Invalid radius - cannot be 0");
        }
        this.arc = arc;
        this.radius = Math.abs(radius);
        double perimeter = radius * arc + 2.0 * radius;
        int particles = (int)(PreviewSettings.density * perimeter);
        this.offset = perimeter / (double)particles;
        this.angleOffset = this.offset / radius;
        this.sin = Math.sin(this.angleOffset);
        this.cos = Math.cos(this.angleOffset);
        this.rSin = Math.sin(arc / 2.0);
        this.rCos = Math.cos(arc / 2.0);
    }

    @Override
    public void playParticles(Player player, ParticleSettings particle, Location location, int step) {
        double startAngle;
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double yaw = (double)location.getYaw() - Math.PI / 180;
        double fx = Math.sin(yaw);
        double fz = Math.cos(yaw);
        double base = PreviewSettings.animation * 0.05 * (double)step % this.offset;
        double ii = Math.sin(startAngle + (yaw += 0.7853981633974483)) * this.radius;
        double jj = Math.cos(startAngle + yaw) * this.radius;
        this.make(player, particle, x, y, z, base, fx * this.rCos + fz * this.rSin, fz * this.rCos - fx * this.rSin);
        this.make(player, particle, x, y, z, this.offset - base, fx * this.rCos - fz * this.rSin, fx * this.rSin + fz * this.rCos);
        for (startAngle = (this.radius - base) % this.offset / this.radius; startAngle < this.arc; startAngle += this.angleOffset) {
            particle.instance(player, x + ii, y, z + jj);
            double temp = ii * this.cos - jj * this.sin;
            jj = ii * this.sin + jj * this.cos;
            ii = temp;
        }
    }

    private void make(Player player, ParticleSettings particle, double x, double y, double z, double pos, double rfx, double rfz) {
        while (pos <= this.radius) {
            particle.instance(player, x + pos * rfx, y, z + pos * rfz);
            pos += this.offset;
        }
    }

    public double getArc() {
        return this.arc;
    }

    public double getRadius() {
        return this.radius;
    }
}

