/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.cast.RoundPreview;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CirclePreview
extends RoundPreview {
    private double radius;
    private double sin;
    private double cos;
    private int particles;

    public CirclePreview(double radius) {
        if (radius == 0.0) {
            throw new IllegalArgumentException("Invalid radius - cannot be 0");
        }
        this.radius = Math.abs(radius);
        this.particles = (int)(PreviewSettings.density * radius * 2.0 * Math.PI);
        double angle = Math.PI * 2 / (double)this.particles;
        this.sin = Math.sin(angle);
        this.cos = Math.cos(angle);
    }

    @Override
    public void playParticles(Player player, ParticleSettings particle, Location location, int step) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double startAngle = (double)step * PreviewSettings.animation / (20.0 * this.radius);
        double ii = Math.sin(startAngle) * this.radius;
        double jj = Math.cos(startAngle) * this.radius;
        for (int i = 0; i < this.particles; ++i) {
            particle.instance(player, x + ii, y, z + jj);
            double temp = ii * this.cos - jj * this.sin;
            jj = ii * this.sin + jj * this.cos;
            ii = temp;
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }
}

