/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.log.Logger;
import java.lang.reflect.Method;
import mc.promcteam.engine.utils.Reflex;
import mc.promcteam.engine.utils.reflection.ReflectionUtil;
import org.bukkit.inventory.ItemStack;

public class DamageLoreRemover {
    private static Class<?> NBT_BASE;
    private static Class<?> NBT_COMPOUND;
    private static Class<?> NBT_LIST;
    private static Class<?> NMS_ITEM;
    private static Class<?> CRAFT_ITEM;
    private static Method SET;
    private static Method SET_TAG;
    private static Method SET_BOOL;
    private static Method SET_INT;
    private static Method GET_TAG;
    private static Method AS_CRAFT;
    private static Method AS_NMS;

    private static void setup() {
        try {
            NBT_BASE = ReflectionUtil.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTBase") : Reflex.getNMSClass((String)"NBTBase");
            NBT_COMPOUND = ReflectionUtil.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTTagCompound") : Reflex.getNMSClass((String)"NBTTagCompound");
            NBT_LIST = ReflectionUtil.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.nbt.NBTTagList") : Reflex.getNMSClass((String)"NBTTagList");
            NMS_ITEM = ReflectionUtil.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.item.ItemStack") : Reflex.getNMSClass((String)"ItemStack");
            CRAFT_ITEM = Reflex.getCraftClass((String)"inventory.CraftItemStack");
            AS_NMS = CRAFT_ITEM.getMethod("asNMSCopy", ItemStack.class);
            AS_CRAFT = CRAFT_ITEM.getMethod("asCraftMirror", NMS_ITEM);
            GET_TAG = NMS_ITEM.getMethod(ReflectionUtil.MINOR_VERSION >= 18 ? "s" : "getTag", new Class[0]);
            SET_TAG = NMS_ITEM.getMethod(ReflectionUtil.MINOR_VERSION >= 18 ? "c" : "setTag", NBT_COMPOUND);
            SET = NBT_COMPOUND.getMethod(ReflectionUtil.MINOR_VERSION >= 18 ? "a" : "set", String.class, NBT_BASE);
            SET_BOOL = NBT_COMPOUND.getMethod(ReflectionUtil.MINOR_VERSION >= 18 ? "a" : "setBoolean", String.class, Boolean.TYPE);
            SET_INT = NBT_COMPOUND.getMethod(ReflectionUtil.MINOR_VERSION >= 18 ? "a" : "setInt", String.class, Integer.TYPE);
        }
        catch (Exception ex) {
            Logger.bug("Failed to set up reflection for removing damage lores.");
        }
    }

    public static ItemStack removeAttackDmg(ItemStack item) {
        if (item == null) {
            return item;
        }
        if (NBT_BASE == null) {
            DamageLoreRemover.setup();
        }
        try {
            item = item.clone();
            Object nmsStack = AS_NMS.invoke(null, item);
            Object nbtCompound = GET_TAG.invoke(nmsStack, new Object[0]);
            if (item.getType().getMaxDurability() > 0) {
                SET_BOOL.invoke(nbtCompound, "Unbreakable", true);
                SET_INT.invoke(nbtCompound, "HideFlags", 4);
            }
            Object nbtTagList = Reflex.getInstance(NBT_LIST, (Object[])new Object[0]);
            SET.invoke(nbtCompound, "AttributeModifiers", nbtTagList);
            SET_TAG.invoke(nmsStack, nbtCompound);
            return (ItemStack)AS_CRAFT.invoke(null, nmsStack);
        }
        catch (Exception ex) {
            return item;
        }
    }
}

