/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.projectile;

import com.sucy.skill.api.particle.target.EffectTarget;
import com.sucy.skill.api.projectile.CustomProjectile;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class HomingProjectile
extends CustomProjectile {
    private static final Vector UP = new Vector(0, 1, 0);
    private final CustomProjectile baseProjectile;
    private final EffectTarget target;
    private final double threshold;
    private final double angle;

    public HomingProjectile(CustomProjectile baseProjectile, EffectTarget target, double angle) {
        super(baseProjectile.getShooter());
        this.baseProjectile = baseProjectile;
        this.target = target;
        this.angle = angle;
        this.threshold = Math.cos(angle);
    }

    @Override
    public Location getLocation() {
        return this.baseProjectile.getLocation();
    }

    @Override
    protected Event expire() {
        return this.baseProjectile.expire();
    }

    @Override
    protected Event land() {
        return this.baseProjectile.land();
    }

    @Override
    protected Event hit(LivingEntity entity) {
        return this.baseProjectile.hit(entity);
    }

    @Override
    protected boolean landed() {
        return this.baseProjectile.landed();
    }

    @Override
    protected double getCollisionRadius() {
        return this.baseProjectile.getCollisionRadius();
    }

    @Override
    protected Vector getVelocity() {
        return this.baseProjectile.getVelocity();
    }

    @Override
    protected void setVelocity(Vector vel) {
        this.baseProjectile.setVelocity(vel);
    }

    public void run() {
        Vector towards;
        Vector targetDir;
        double speed;
        Vector vel = this.getVelocity();
        Vector dir = vel.multiply(1.0 / (speed = vel.length()));
        double dot = dir.dot(targetDir = (towards = this.target.getLocation().toVector().subtract(this.getLocation().toVector())).normalize());
        if (dot >= this.threshold) {
            this.setVelocity(targetDir.multiply(speed));
        } else {
            double diff = Math.acos(dot);
            double t = this.angle / diff;
            double d = Math.sin(diff);
        }
    }
}

