/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.player;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerSkillSlot {
    private final ArrayList<PlayerSkill> skills = new ArrayList();
    private int index = 0;
    private PlayerData player;

    public void init(PlayerData data) {
        this.player = data;
        this.index = 0;
        this.skills.clear();
        for (PlayerSkill skill : data.getSkills()) {
            if (!skill.getData().canCast() || !skill.isUnlocked()) continue;
            this.skills.add(skill);
        }
    }

    public ItemStack getDisplay() {
        return this.skills.size() == 0 ? SkillAPI.getSettings().getCastItem() : this.skills.get(this.index).getData().getIndicator(this.skills.get(this.index), true);
    }

    public void unlock(PlayerSkill skill) {
        if (skill.isUnlocked() && skill.getData().canCast()) {
            this.skills.add(skill);
        }
    }

    public void clear(PlayerSkill skill) {
        if (skill.getData().canCast()) {
            this.skills.remove(skill);
            this.index = Math.max(Math.min(this.index, this.skills.size() - 1), 0);
        }
    }

    public void clearAll() {
        this.skills.clear();
        this.index = 0;
    }

    public void updateItem(Player player) {
        if (player != null) {
            player.getInventory().setItem(SkillAPI.getSettings().getCastSlot(), this.getDisplay());
        }
    }

    public void activate() {
        if (this.skills.size() > 0) {
            this.player.cast(this.skills.get(this.index));
        }
    }

    public void next() {
        if (this.skills.size() > 0) {
            this.index = (this.index + 1) % this.skills.size();
            this.updateItem(this.player.getPlayer());
        }
    }

    public void prev() {
        if (this.skills.size() > 0) {
            this.index = (this.index + this.skills.size() - 1) % this.skills.size();
            this.updateItem(this.player.getPlayer());
        }
    }
}

