/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.player;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.SkillStatus;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public final class PlayerSkill {
    private Skill skill;
    private PlayerData player;
    private PlayerClass parent;
    private Material bind;
    private long cooldown;
    private int level;

    public PlayerSkill(PlayerData player, Skill skill, PlayerClass parent) {
        this.player = player;
        this.skill = skill;
        this.parent = parent;
    }

    public boolean isUnlocked() {
        return this.level > 0;
    }

    public Skill getData() {
        return this.skill;
    }

    public PlayerClass getPlayerClass() {
        return this.parent;
    }

    public PlayerData getPlayerData() {
        return this.player;
    }

    public Material getBind() {
        return this.bind;
    }

    public int getLevel() {
        return this.level;
    }

    public int getCost() {
        return this.skill.getCost(this.level);
    }

    public int getInvestedCost() {
        int total = 0;
        for (int i = 0; i < this.level; ++i) {
            total += this.skill.getCost(i);
        }
        return total;
    }

    public double getManaCost() {
        return this.skill.getManaCost(this.level);
    }

    public int getLevelReq() {
        return this.skill.getLevelReq(this.level);
    }

    public boolean isOnCooldown() {
        return this.cooldown > System.currentTimeMillis();
    }

    public boolean isMaxed() {
        return this.level >= this.skill.getMaxLevel();
    }

    public int getCooldown() {
        if (this.isOnCooldown()) {
            return (int)((this.cooldown - System.currentTimeMillis() + 999L) / 1000L);
        }
        return 0;
    }

    public SkillStatus getStatus() {
        if (this.isOnCooldown()) {
            return SkillStatus.ON_COOLDOWN;
        }
        if (SkillAPI.getSettings().isManaEnabled() && this.player.getMana() < this.skill.getManaCost(this.level)) {
            return SkillStatus.MISSING_MANA;
        }
        return SkillStatus.READY;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void addLevels(int amount) {
        this.level = Math.min(this.level + amount, this.skill.getMaxLevel());
    }

    public void setBind(Material mat) {
        this.bind = mat;
        this.getPlayerData().bind(mat, this);
    }

    public void revert() {
        this.parent.givePoints(this.getInvestedCost());
        this.level = 0;
    }

    public void startCooldown() {
        long cd = (long)this.player.scaleStat("cooldown", this.skill.getCooldown(this.level) * 1000.0);
        this.cooldown = System.currentTimeMillis() + cd;
    }

    public void refreshCooldown() {
        this.cooldown = 0L;
    }

    public void subtractCooldown(double seconds) {
        this.addCooldown(-seconds);
    }

    public void addCooldown(double seconds) {
        this.cooldown = this.isOnCooldown() ? (this.cooldown += (long)((int)(seconds * 1000.0))) : System.currentTimeMillis() + (long)((int)(seconds * 1000.0));
    }

    public void playParticles(Player player, int step) {
        this.skill.playPreview(player, this.level, step);
    }
}

