/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.player;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.PlayerComboFinishEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.data.Click;
import com.sucy.skill.log.Logger;
import com.sucy.skill.manager.ComboManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class PlayerCombos {
    private HashMap<Integer, String> skills = new HashMap();
    private HashMap<String, Integer> reverse = new HashMap();
    private PlayerData player;
    private Click[] clicks;
    private int clickIndex;
    private long clickTime;

    public PlayerCombos(PlayerData data) {
        this.player = data;
        this.clickIndex = 0;
        this.clicks = new Click[SkillAPI.getComboManager().getComboSize()];
        this.clickTime = 0L;
    }

    public int getComboCount() {
        return this.clickIndex;
    }

    public HashMap<Integer, String> getSkillMap() {
        return this.skills;
    }

    public PlayerData getPlayerData() {
        return this.player;
    }

    public String getSkillName(int id) {
        return this.skills.get(id);
    }

    public void clearCombo() {
        this.clickIndex = 0;
    }

    public void applyClick(Click click) {
        if (!SkillAPI.getComboManager().isClickEnabled(click.getId())) {
            return;
        }
        this.checkExpired();
        this.clicks[this.clickIndex++] = click;
        this.clickTime = System.currentTimeMillis();
        int id = SkillAPI.getComboManager().convertCombo(this.clicks, this.clickIndex);
        if (this.clickIndex == this.clicks.length || this.skills.containsKey(id)) {
            PlayerComboFinishEvent event = new PlayerComboFinishEvent(this.player, id, this.skills.get(id));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (this.skills.containsKey(id) && !event.isCancelled()) {
                this.player.cast(this.skills.get(id));
            }
        }
    }

    private void checkExpired() {
        if (this.clickIndex == this.clicks.length || System.currentTimeMillis() - this.clickTime > (long)SkillAPI.getSettings().getClickTime()) {
            this.clearCombo();
        }
    }

    public String getCurrentComboString() {
        if (this.clickIndex == 0) {
            return "";
        }
        if (this.clickIndex == this.clicks.length) {
            int id = SkillAPI.getComboManager().convertCombo(this.clicks);
            this.checkExpired();
            if (this.skills.containsKey(id)) {
                return SkillAPI.getSkill(this.skills.get(id)).getName();
            }
            return "";
        }
        this.checkExpired();
        ArrayList<Click> active = new ArrayList<Click>(this.clickIndex);
        for (int i = 0; i < this.clickIndex; ++i) {
            active.add(this.clicks[i]);
        }
        return SkillAPI.getComboManager().getComboString(active);
    }

    public boolean hasConflict(int id) {
        return this.getConflicts(id).size() > 0;
    }

    public List<Integer> getConflicts(int id) {
        ComboManager cm = SkillAPI.getComboManager();
        ArrayList<Integer> conflicts = new ArrayList<Integer>();
        for (int taken : this.skills.keySet()) {
            if (!cm.conflicts(id, taken)) continue;
            conflicts.add(taken);
        }
        return conflicts;
    }

    public void addSkill(Skill skill) {
        int combo;
        if (skill == null || !skill.canCast() || !SkillAPI.getSettings().isCombosEnabled()) {
            return;
        }
        if (skill.hasCombo()) {
            this.setSkill(skill, skill.getCombo());
            return;
        }
        if (!SkillAPI.getSettings().shouldAutoAssignCombos()) {
            return;
        }
        ComboManager cm = SkillAPI.getComboManager();
        int max = (1 << 4 * cm.getComboSize()) - 1;
        for (combo = 1 << 4 * (cm.getComboSize() - 1); combo <= max && (!cm.isValidDefaultCombo(combo) || this.hasConflict(combo)); ++combo) {
        }
        if (combo <= max) {
            this.skills.put(combo, skill.getName().toLowerCase());
            this.reverse.put(skill.getName(), combo);
        } else {
            Logger.invalid("Failed to assign combo for " + skill.getName() + " - no remaining combos");
        }
    }

    public void removeSkill(Skill skill) {
        if (skill == null || !this.reverse.containsKey(skill.getName())) {
            return;
        }
        this.skills.remove(this.reverse.remove(skill.getName()));
    }

    public boolean isComboUsed(int id) {
        return this.skills.containsKey(id);
    }

    public boolean isValidCombo(int id) {
        return SkillAPI.getComboManager().isValidCombo(id);
    }

    public boolean hasCombo(Skill skill) {
        return this.reverse.containsKey(skill.getName());
    }

    public boolean setSkill(Skill skill, int id) {
        if (skill == null || !skill.canCast() || !this.isValidCombo(id)) {
            return false;
        }
        this.removeSkill(skill);
        List<Integer> conflicts = this.getConflicts(id);
        if (conflicts.size() > 0) {
            Skill old;
            for (int conflict : conflicts) {
                if (conflict != id) continue;
                old = SkillAPI.getSkill(this.skills.get(conflict));
                old.clearCombo();
                this.addSkill(old);
            }
            this.skills.put(id, skill.getName().toLowerCase());
            this.reverse.put(skill.getName(), id);
            for (int conflict : conflicts) {
                if (conflict == id) continue;
                old = SkillAPI.getSkill(this.skills.get(conflict));
                old.clearCombo();
                this.addSkill(old);
                this.reverse.remove(this.skills.remove(conflict));
            }
        } else {
            this.skills.put(id, skill.getName().toLowerCase());
            this.reverse.put(skill.getName(), id);
        }
        return true;
    }

    public String getComboString(Skill skill) {
        int combo = this.reverse.get(skill.getName());
        return SkillAPI.getComboManager().getComboString(combo);
    }
}

