/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.player;

import com.google.common.base.Preconditions;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.enums.PointSource;
import com.sucy.skill.api.event.PlayerExperienceGainEvent;
import com.sucy.skill.api.event.PlayerExperienceLostEvent;
import com.sucy.skill.api.event.PlayerGainSkillPointsEvent;
import com.sucy.skill.api.event.PlayerLevelDownEvent;
import com.sucy.skill.api.event.PlayerLevelUpEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.data.TitleType;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.manager.TitleManager;
import mc.promcteam.engine.mccore.config.Filter;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerClass {
    private final PlayerData player;
    private RPGClass classData;
    private int level;
    private int points;
    private double exp;

    public PlayerClass(PlayerData player, RPGClass classData) {
        this.player = player;
        this.classData = classData;
        this.level = 1;
        this.points = SkillAPI.getSettings().getGroupSettings(classData.getGroup()).getStartingPoints();
        this.exp = 0.0;
        for (Skill skill : classData.getSkills()) {
            player.giveSkill(skill, this);
        }
    }

    public PlayerData getPlayerData() {
        return this.player;
    }

    public RPGClass getData() {
        return this.classData;
    }

    public double getExp() {
        return this.exp;
    }

    public void setExp(double exp) {
        this.exp = Math.max(Math.min(exp, (double)(this.getRequiredExp() - 1)), 0.0);
    }

    public int getRequiredExp() {
        return this.classData.getRequiredExp(this.level);
    }

    public double getTotalExp() {
        double exp = this.exp;
        for (int i = 1; i < this.level; ++i) {
            exp += (double)this.classData.getRequiredExp(i);
        }
        return exp;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Cannot be a level less than 1");
        }
        this.level = level;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Invalid point amount - cannot be less than 1");
        }
        this.points = amount;
    }

    public boolean isLevelMaxed() {
        return this.level == this.classData.getMaxLevel();
    }

    public double getHealth() {
        return this.classData.getHealth(this.level);
    }

    public double getMana() {
        return this.classData.getMana(this.level);
    }

    public void givePoints(int amount) {
        this.givePoints(amount, PointSource.SPECIAL);
    }

    public void givePoints(int amount, PointSource source) {
        if (amount < 1) {
            throw new IllegalArgumentException("Invalid point amount - cannot be less than 1");
        }
        PlayerGainSkillPointsEvent event = new PlayerGainSkillPointsEvent(this, amount, source);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.points = (int)((double)this.points + event.getAmount());
        }
    }

    public void usePoints(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Invalid points amount - cannot be less than 1");
        }
        if (amount > this.points) {
            throw new IllegalArgumentException("Invalid points amount - more than current total");
        }
        this.points -= amount;
    }

    public void giveExp(double amount, ExpSource source) {
        this.giveExp(amount, source, true);
    }

    public void giveExp(double amount, ExpSource source, boolean showMessage) {
        if (amount <= 0.0) {
            return;
        }
        PlayerExperienceGainEvent event = new PlayerExperienceGainEvent(this, amount, source);
        event.setCancelled(!this.classData.receivesExp(source) || this.level >= this.classData.getMaxLevel());
        Bukkit.getPluginManager().callEvent((Event)event);
        int rounded = (int)Math.ceil(event.getExp());
        if (!event.isCancelled() && rounded > 0) {
            if (showMessage && SkillAPI.getSettings().isShowExpMessages() && this.player.getPlayer() != null) {
                TitleManager.show(this.player.getPlayer(), TitleType.EXP_GAINED, "Notifications.gain-exp", RPGFilter.EXP.setReplacement("" + rounded), RPGFilter.CLASS.setReplacement(this.classData.getName()), Filter.AMOUNT.setReplacement("" + rounded));
            }
            this.exp += (double)rounded;
            this.checkLevelUp();
        }
    }

    public void loseExp(double amount, boolean percent, boolean changeLevel) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (Object)"Amount must be positive");
        if (percent) {
            amount *= (double)this.getRequiredExp();
        }
        PlayerExperienceLostEvent event = new PlayerExperienceLostEvent(this, amount, changeLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            changeLevel = event.isLevelChangeAllowed();
            if (!changeLevel) {
                amount = Math.min(event.getExp(), this.exp);
            }
            this.exp -= amount;
            if (SkillAPI.getSettings().isShowLossExpMessages() && (int)amount > 0) {
                TitleManager.show(this.player.getPlayer(), TitleType.EXP_LOST, "Notifications.lose-exp", RPGFilter.EXP.setReplacement("" + (int)amount), RPGFilter.CLASS.setReplacement(this.classData.getName()), Filter.AMOUNT.setReplacement("" + (int)amount));
            }
            this.checkLevelDown();
        }
    }

    public void loseExp(double percent) {
        this.loseExp(percent, true, false);
    }

    private void checkLevelUp() {
        int levels = 0;
        while (true) {
            int n;
            int required = this.classData.getRequiredExp(this.level + levels);
            if (!(this.exp >= (double)n) || this.level + levels >= this.classData.getMaxLevel()) break;
            this.exp -= (double)required;
            ++levels;
        }
        if (levels > 0) {
            this.giveLevels(levels);
            if (SkillAPI.getSettings().isShowLevelMessages()) {
                TitleManager.show(this.player.getPlayer(), TitleType.LEVEL_UP, "Notifications.gain-lvl", RPGFilter.LEVEL.setReplacement("" + this.level), RPGFilter.CLASS.setReplacement(this.classData.getName()), RPGFilter.POINTS.setReplacement("" + this.points), Filter.AMOUNT.setReplacement("" + levels));
            }
        }
    }

    private void checkLevelDown() {
        int levels = 0;
        while (this.exp < 0.0) {
            if (this.level - levels == 1) {
                this.exp = 0.0;
                break;
            }
            this.exp += (double)this.classData.getRequiredExp(this.level - ++levels);
        }
        if (levels == 0) {
            return;
        }
        this.loseLevels(levels);
        if (SkillAPI.getSettings().isShowLossLevelMessages()) {
            TitleManager.show(this.player.getPlayer(), TitleType.LEVEL_DOWN, "Notifications.lose-lvl", RPGFilter.LEVEL.setReplacement("" + this.level), RPGFilter.CLASS.setReplacement(this.classData.getName()), RPGFilter.POINTS.setReplacement("" + this.points), Filter.AMOUNT.setReplacement("" + levels));
        }
    }

    public void giveLevels(int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("Invalid level amount - cannot be less than 1");
        }
        if ((amount = Math.min(amount, this.classData.getMaxLevel() - this.level)) <= 0) {
            return;
        }
        this.level += amount;
        this.points += this.classData.getGroupSettings().getPointsForLevels(this.level, this.level - amount);
        this.getPlayerData().giveAttribPoints(this.classData.getGroupSettings().getAttribsForLevels(this.level, this.level - amount));
        Player player = this.getPlayerData().getPlayer();
        if (player != null) {
            this.getPlayerData().updatePlayerStat(this.getPlayerData().getPlayer());
            this.getPlayerData().getEquips().update(this.getPlayerData().getPlayer());
        }
        this.getPlayerData().autoLevel();
        PlayerLevelUpEvent event = new PlayerLevelUpEvent(this, amount);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (SkillAPI.getSettings().hasLevelUpEffect()) {
            DynamicSkill skill = SkillAPI.getSettings().getLevelUpSkill();
            skill.cast((LivingEntity)player, this.level);
        }
    }

    public void loseLevels(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Invalid level amount - cannot be less than 1");
        }
        if ((amount = Math.min(amount, this.level - 1)) <= 0) {
            return;
        }
        this.level -= amount;
        this.points += this.classData.getGroupSettings().getPointsForLevels(this.level, this.level + amount);
        this.getPlayerData().giveAttribPoints(this.classData.getGroupSettings().getAttribsForLevels(this.level, this.level + amount));
        Player player = this.getPlayerData().getPlayer();
        if (player != null) {
            this.getPlayerData().updatePlayerStat(this.getPlayerData().getPlayer());
            this.getPlayerData().getEquips().update(this.getPlayerData().getPlayer());
        }
        this.getPlayerData().autoLevel();
        PlayerLevelDownEvent event = new PlayerLevelDownEvent(this, amount);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (SkillAPI.getSettings().hasLevelUpEffect()) {
            DynamicSkill skill = SkillAPI.getSettings().getLevelUpSkill();
            skill.cast((LivingEntity)player, this.level);
        }
    }

    public void setClassData(RPGClass classData) {
        RPGClass previous = this.classData;
        this.classData = classData;
        this.getPlayerData().setClass(previous, classData, false);
    }
}

