/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.enums.Direction;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class ParticleHelper {
    public static final String ARRANGEMENT_KEY = "arrangement";
    public static final String POINTS_KEY = "particles";
    public static final String LEVEL = "level";
    public static final String PARTICLE_KEY = "particle";
    public static final String MATERIAL_KEY = "material";
    public static final String CMD_KEY = "type";
    public static final String DURABILITY_KEY = "durability";
    public static final String RADIUS_KEY = "radius";
    public static final String AMOUNT_KEY = "amount";
    public static final String DIRECTION_KEY = "direction";
    public static final String VISIBLE_RADIUS_KEY = "visible-radius";
    public static final String DX_KEY = "dx";
    public static final String DY_KEY = "dy";
    public static final String DZ_KEY = "dz";
    public static final String SPEED_KEY = "speed";
    public static final String DUST_COLOR = "dust-color";
    public static final String FINAL_DUST_COLOR = "final-dust-color";
    public static final String DUST_SIZE = "dust-size";
    private static final Random random = new Random();

    private ParticleHelper() {
    }

    public static Particle getFromKey(String particleKey) {
        return Particle.valueOf((String)particleKey.toUpperCase().replace(' ', '_'));
    }

    public static void play(Location loc, Settings settings) {
        double visibleRadius = settings.getDouble(VISIBLE_RADIUS_KEY, 25.0);
        Particle particle = ParticleHelper.getFromKey(settings.getString(PARTICLE_KEY, "Villager happy"));
        int amount = settings.getInt(AMOUNT_KEY, 1);
        double dx = settings.getDouble(DX_KEY, 0.0);
        double dy = settings.getDouble(DY_KEY, 0.0);
        double dz = settings.getDouble(DZ_KEY, 0.0);
        float speed = (float)settings.getDouble(SPEED_KEY, 0.1);
        Object object = ParticleHelper.makeObject(particle, settings);
        String arrangement = settings.getString(ARRANGEMENT_KEY, "").toLowerCase();
        int level = settings.getInt(LEVEL, 1);
        int points = (int)settings.getAttr(POINTS_KEY, 0, 20.0);
        switch (arrangement) {
            case "circle": {
                ParticleHelper.fillCircle(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object);
                break;
            }
            case "sphere": {
                ParticleHelper.fillSphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object);
                break;
            }
            case "hemisphere": {
                ParticleHelper.fillHemisphere(loc, settings, level, points, visibleRadius, particle, amount, dx, dy, dz, speed, object);
                break;
            }
            default: {
                ParticleHelper.filterPlayers(Objects.requireNonNull(loc.getWorld()).getPlayers(), loc, visibleRadius).forEach(player -> player.spawnParticle(particle, loc, amount, dx, dy, dz, (double)speed, object));
            }
        }
    }

    public static void fillCircle(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        double radius = settings.getAttr(RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        Direction direction = null;
        if (settings.has(DIRECTION_KEY)) {
            try {
                direction = Direction.valueOf(settings.getString(DIRECTION_KEY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (direction == null) {
            direction = Direction.XZ;
        }
        while (index < points) {
            if (direction == Direction.XY || direction == Direction.XZ) {
                temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            }
            if (direction == Direction.XY || direction == Direction.YZ) {
                temp.setY(loc.getY() + random.nextDouble() * twoRadius - radius);
            }
            if (direction == Direction.XZ || direction == Direction.YZ) {
                temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            }
            if (temp.distanceSquared(loc) > rSquared) continue;
            ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius).forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static void fillSphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        double radius = settings.getAttr(RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        while (index < points) {
            temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            temp.setY(loc.getY() + random.nextDouble() * twoRadius - radius);
            temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            if (temp.distanceSquared(loc) > rSquared) continue;
            ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius).forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static void fillHemisphere(Location loc, Settings settings, int level, int points, double visibleRadius, Particle particle, int amount, double dx, double dy, double dz, float speed, Object object) {
        double radius = settings.getAttr(RADIUS_KEY, level, 3.0);
        World world = Objects.requireNonNull(loc.getWorld());
        List worldPlayers = world.getPlayers();
        double rSquared = radius * radius;
        double twoRadius = radius * 2.0;
        Location temp = loc.clone();
        int index = 0;
        while (index < points) {
            temp.setX(loc.getX() + random.nextDouble() * twoRadius - radius);
            temp.setY(loc.getY() + random.nextDouble() * radius);
            temp.setZ(loc.getZ() + random.nextDouble() * twoRadius - radius);
            if (temp.distanceSquared(loc) > rSquared) continue;
            ParticleHelper.filterPlayers(worldPlayers, temp, visibleRadius).forEach(player -> player.spawnParticle(particle, temp, amount, dx, dy, dz, (double)speed, object));
            ++index;
        }
    }

    public static Object makeObject(Particle particle, Settings settings) {
        return ParticleHelper.makeObject(particle, Material.valueOf((String)settings.getString(MATERIAL_KEY, "DIRT").toUpperCase().replace(" ", "_")), settings.getInt(CMD_KEY, 0), settings.getInt(DURABILITY_KEY, 0), Color.fromRGB((int)Integer.parseInt(settings.getString(DUST_COLOR, "#FF0000").substring(1), 16)), Color.fromRGB((int)Integer.parseInt(settings.getString(FINAL_DUST_COLOR, "#FF0000").substring(1), 16)), (float)settings.getDouble(DUST_SIZE, 1.0));
    }

    public static Object makeObject(Particle particle, Material material, int cmd, int durability, Color dustColor, Color toColor, float dustSize) {
        BlockData object = null;
        switch (particle) {
            case REDSTONE: {
                object = new Particle.DustOptions(dustColor, dustSize);
                break;
            }
            case ITEM_CRACK: {
                ItemStack item = new ItemStack(material);
                ItemMeta meta = Objects.requireNonNull(item.getItemMeta());
                meta.setCustomModelData(Integer.valueOf(cmd));
                if (meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(durability);
                }
                item.setItemMeta(meta);
                object = item;
                break;
            }
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: 
            case BLOCK_MARKER: {
                object = material.createBlockData();
                break;
            }
            case DUST_COLOR_TRANSITION: {
                object = new Particle.DustTransition(dustColor, toColor, dustSize);
            }
        }
        return object;
    }

    public static Set<Player> filterPlayers(Collection<Player> players, Location location, double visibleRadius) {
        visibleRadius *= visibleRadius;
        HashSet<Player> result = new HashSet<Player>();
        for (Player player : players) {
            if (!(location.distanceSquared(player.getLocation()) <= visibleRadius)) continue;
            result.add(player);
        }
        return result;
    }
}

