/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.particle.ParticleEffect;
import com.sucy.skill.api.particle.target.EffectTarget;

public class EffectInstance {
    private final ParticleEffect effect;
    private final EffectTarget target;
    private final int level;
    private int life;
    private int tick;
    private int frame;

    public EffectInstance(ParticleEffect effect, EffectTarget target, int level) {
        this.effect = effect;
        this.target = target;
        this.level = level;
        this.life = 0;
        this.tick = -1;
        this.frame = 0;
    }

    public boolean isValid() {
        return this.target.isValid() && this.life > 0;
    }

    public void extend(int duration) {
        this.life = Math.max(this.life, duration);
    }

    public void tick() {
        ++this.tick;
        if (this.tick % this.effect.getInterval() == 0) {
            this.effect.play(this.target.getLocation(), this.frame, this.level);
            ++this.frame;
            this.tick = 0;
        }
        --this.life;
    }
}

