/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.classes;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.ReadOnlySettings;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.classes.DefaultTreeType;
import com.sucy.skill.api.classes.TreeType;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.util.Data;
import com.sucy.skill.data.GroupSettings;
import com.sucy.skill.gui.tool.IconHolder;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class RPGClass
implements IconHolder {
    private static final String SKILLS = "skills";
    private static final String PARENT = "parent";
    private static final String NAME = "name";
    private static final String PREFIX = "prefix";
    private static final String ACTION_BAR = "action-bar";
    private static final String GROUP = "group";
    private static final String MANA = "mana";
    private static final String MAX = "max-level";
    private static final String EXP = "exp-source";
    private static final String REGEN = "mana-regen";
    private static final String PERM = "needs-permission";
    private static final String ATTR = "attributes";
    private static final String TREE = "tree";
    private static final String BLACKLIST = "blacklist";
    protected final Settings settings = new Settings();
    private final HashMap<String, Skill> skillMap = new HashMap();
    private final ArrayList<Skill> skills = new ArrayList();
    private final HashSet<Material> blacklist = new HashSet();
    private final ReadOnlySettings readOnlySettings = new ReadOnlySettings(this.settings);
    protected boolean needsPermission;
    protected String actionBar = "";
    private InventoryTree skillTree;
    private String parent;
    private ItemStack icon;
    private TreeType tree;
    private String name;
    private String prefix;
    private String group;
    private String mana;
    private int maxLevel;
    private int expSources;
    private double manaRegen;

    protected RPGClass(String name, ItemStack icon, int maxLevel) {
        this(name, icon, maxLevel, null, null);
    }

    protected RPGClass(String name, ItemStack icon, int maxLevel, String parent) {
        this(name, icon, maxLevel, null, parent);
    }

    protected RPGClass(String name, ItemStack icon, int maxLevel, String group, String parent) {
        this.parent = parent;
        this.icon = icon;
        this.name = name;
        this.prefix = name;
        this.group = group == null ? "class" : group.toLowerCase();
        this.mana = "Mana";
        this.maxLevel = maxLevel;
        this.tree = DefaultTreeType.REQUIREMENT;
        this.setAllowedExpSources(ExpSource.MOB, ExpSource.COMMAND, ExpSource.QUEST);
        if (this instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SkillAPI.inst());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public ChatColor getPrefixColor() {
        String colors = ChatColor.getLastColors((String)this.prefix);
        if (colors.length() < 2) {
            return ChatColor.WHITE;
        }
        return ChatColor.getByChar((char)colors.charAt(1));
    }

    public InventoryTree getSkillTree() {
        return this.skillTree;
    }

    public String getGroup() {
        return this.group;
    }

    public GroupSettings getGroupSettings() {
        return SkillAPI.getSettings().getGroupSettings(this.group);
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public RPGClass getParent() {
        return SkillAPI.getClass(this.parent);
    }

    public RPGClass getRoot() {
        RPGClass root = this;
        while (root.parent != null) {
            root = root.getParent();
        }
        return root;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public HashMap<String, Skill> getSkillMap() {
        if (this.skillMap.isEmpty()) {
            for (RPGClass current = this; current != null; current = current.getParent()) {
                for (Skill skill : current.skills) {
                    this.skillMap.put(skill.getName().toLowerCase(), skill);
                }
            }
        }
        return this.skillMap;
    }

    @Override
    public ItemStack getIcon(PlayerData data) {
        return this.getIcon();
    }

    @Override
    public boolean isAllowed(Player player) {
        return !this.needsPermission || player.hasPermission("skillapi.class") || player.hasPermission("skillapi.class." + this.name.toLowerCase().replace(" ", "-"));
    }

    public ItemStack getToolIcon() {
        List lore;
        ItemStack item = new ItemStack(this.icon.getType());
        ItemMeta iconMeta = this.icon.getItemMeta();
        ItemMeta meta = item.getItemMeta();
        List list = lore = iconMeta.hasLore() ? iconMeta.getLore() : new ArrayList();
        if (iconMeta.hasDisplayName()) {
            lore.add(0, iconMeta.getDisplayName());
        }
        meta.setDisplayName(this.name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public String getActionBarText() {
        return this.actionBar;
    }

    public void setActionBarText(String text) {
        this.actionBar = text;
    }

    public boolean hasActionBarText() {
        return this.actionBar.trim().length() > 0;
    }

    public boolean receivesExp(ExpSource source) {
        return (this.expSources & source.getId()) != 0;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getRequiredExp(int level) {
        return SkillAPI.getSettings().getRequiredExp(level);
    }

    public double getHealth(int level) {
        return this.settings.getAttr("health", level);
    }

    public double getBaseHealth() {
        return this.settings.getBase("health");
    }

    public double getHealthScale() {
        return this.settings.getScale("health");
    }

    public double getMana(int level) {
        return this.settings.getAttr(MANA, level);
    }

    public double getBaseMana() {
        return this.settings.getBase(MANA);
    }

    public double getManaScale() {
        return this.settings.getScale(MANA);
    }

    public int getAttribute(String key, int level) {
        return (int)this.settings.getAttr(key, level, 0.0);
    }

    public ReadOnlySettings getSettings() {
        return this.readOnlySettings;
    }

    public String getManaName() {
        return this.mana;
    }

    public void setManaName(String name) {
        this.mana = name;
    }

    public List<Skill> getSkills() {
        return this.getSkills(true);
    }

    public List<Skill> getSkills(boolean includeParent) {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        skills.addAll(this.skills);
        if (this.hasParent() && includeParent) {
            skills.addAll(this.getParent().getSkills());
        }
        return skills;
    }

    public boolean hasManaRegen() {
        return this.manaRegen > 0.0;
    }

    public double getManaRegen() {
        return this.manaRegen;
    }

    public void setManaRegen(double amount) {
        this.manaRegen = amount;
    }

    public ArrayList<RPGClass> getOptions() {
        ArrayList<RPGClass> list = new ArrayList<RPGClass>();
        for (RPGClass c : SkillAPI.getClasses().values()) {
            if (c.getParent() != this) continue;
            list.add(c);
        }
        return list;
    }

    public boolean canUse(Material type) {
        return !this.blacklist.contains(type);
    }

    public void addSkill(String name) {
        Skill skill = SkillAPI.getSkill(name);
        if (skill != null) {
            this.skills.add(skill);
        } else {
            Logger.invalid("Class \"" + this.name + "\" tried to add an invalid skill - \"" + name + "\"");
        }
    }

    public void addSkills(String ... names) {
        for (String name : names) {
            this.addSkill(name);
        }
    }

    public void setAllowedExpSources(ExpSource ... sources) {
        this.expSources = 0;
        for (ExpSource source : sources) {
            this.allowExpSource(source);
        }
    }

    public void allowExpSource(ExpSource source) {
        this.expSources |= source.getId();
    }

    public void disallowExpSource(ExpSource source) {
        this.expSources &= ~source.getId();
    }

    public void save(DataSection config) {
        config.set(NAME, (Object)this.name);
        config.set(ACTION_BAR, (Object)this.actionBar.replace('\u00a7', '&'));
        config.set(PREFIX, (Object)this.prefix.replace('\u00a7', '&'));
        config.set(GROUP, (Object)this.group);
        config.set(MANA, (Object)this.mana.replace('\u00a7', '&'));
        config.set(MAX, (Object)this.maxLevel);
        config.set(PARENT, (Object)this.parent);
        config.set(PERM, (Object)this.needsPermission);
        this.settings.save(config.createSection(ATTR));
        config.set(REGEN, (Object)this.manaRegen);
        config.set(TREE, (Object)this.tree.toString());
        config.set(BLACKLIST, new ArrayList<Material>(this.blacklist));
        ArrayList<String> skillNames = new ArrayList<String>();
        for (Skill skill : this.skills) {
            skillNames.add(skill.getName());
        }
        config.set(SKILLS, skillNames);
        Data.serializeIcon(this.icon, config);
        config.set(EXP, (Object)this.expSources);
    }

    public void softSave(DataSection config) {
        boolean neededOnly;
        boolean bl = neededOnly = config.keys().size() > 0;
        if (!neededOnly) {
            this.save(config);
        }
    }

    public void load(DataSection config) {
        this.parent = config.getString(PARENT);
        this.icon = Data.parseIcon(config);
        this.name = config.getString(NAME, this.name);
        this.actionBar = TextFormatter.colorString((String)config.getString(ACTION_BAR, ""));
        this.prefix = TextFormatter.colorString((String)config.getString(PREFIX, this.prefix));
        this.group = config.getString(GROUP, "class");
        this.mana = TextFormatter.colorString((String)config.getString(MANA, this.mana));
        this.maxLevel = config.getInt(MAX, this.maxLevel);
        this.expSources = config.getInt(EXP, this.expSources);
        this.manaRegen = config.getDouble(REGEN, this.manaRegen);
        this.needsPermission = config.getString(PERM, "" + this.needsPermission).equalsIgnoreCase("true");
        this.tree = DefaultTreeType.getByName(config.getString(TREE, "requirement"));
        for (String type : config.getList(BLACKLIST)) {
            if (type.isEmpty()) continue;
            Material mat = Material.matchMaterial((String)type.toUpperCase().replace(' ', '_'));
            if (mat != null) {
                this.blacklist.add(mat);
                continue;
            }
            Logger.invalid(type + " is not a valid material for class " + this.name);
        }
        this.settings.load(config.getSection(ATTR));
        if (config.isList(SKILLS)) {
            this.skills.clear();
            for (String name : config.getList(SKILLS)) {
                Skill skill = SkillAPI.getSkill(name);
                if (skill != null) {
                    this.skills.add(skill);
                    continue;
                }
                Logger.invalid("Invalid skill for class " + this.name + " - " + name);
            }
        }
        this.skillTree = this.tree.getTree(SkillAPI.inst(), this);
    }

    public void arrange() {
        try {
            Logger.log(LogType.REGISTRATION, 2, "Arranging for \"" + this.name + "\" - " + this.skills.size() + " skills");
            this.skillTree.arrange();
        }
        catch (Exception ex) {
            Logger.invalid("Failed to arrange skill tree for class \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public boolean isNeedsPermission() {
        return this.needsPermission;
    }
}

