/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api;

import com.sucy.skill.api.CombatProtection;
import com.sucy.skill.hook.NoCheatHook;
import com.sucy.skill.hook.PluginChecker;
import mc.promcteam.engine.mccore.util.Protection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;

public class DefaultCombatProtection
implements CombatProtection {
    @Override
    public boolean canAttack(Player attacker, Player defender) {
        return this.canAttack(attacker, defender, EntityDamageEvent.DamageCause.CUSTOM);
    }

    @Override
    public boolean canAttack(Player attacker, LivingEntity defender) {
        return this.canAttack(attacker, defender, EntityDamageEvent.DamageCause.CUSTOM);
    }

    @Override
    public boolean canAttack(LivingEntity attacker, LivingEntity defender) {
        return this.canAttack(attacker, defender, EntityDamageEvent.DamageCause.CUSTOM);
    }

    @Override
    public boolean canAttack(Player attacker, Player defender, EntityDamageEvent.DamageCause cause) {
        return this.canAttack((LivingEntity)attacker, (LivingEntity)defender, cause);
    }

    @Override
    public boolean canAttack(Player attacker, LivingEntity defender, EntityDamageEvent.DamageCause cause) {
        return this.canAttack((LivingEntity)attacker, defender, cause);
    }

    @Override
    public boolean canAttack(LivingEntity attacker, LivingEntity defender, EntityDamageEvent.DamageCause cause) {
        boolean canAttack;
        if (PluginChecker.isNoCheatActive() && attacker instanceof Player) {
            Player player = (Player)attacker;
            NoCheatHook.exempt(player);
            canAttack = Protection.canAttack((LivingEntity)attacker, (LivingEntity)defender);
            NoCheatHook.unexempt(player);
        } else {
            canAttack = CombatProtection.canAttack(attacker, defender, false, cause);
        }
        return canAttack;
    }

    public static class FakeEntityDamageByEntityEvent
    extends EntityDamageByEntityEvent {
        public boolean externallyCancelled = false;

        public FakeEntityDamageByEntityEvent(@NotNull Entity damager, @NotNull Entity damagee, @NotNull EntityDamageEvent.DamageCause cause, double damage) {
            super(damager, damagee, cause, damage);
        }

        public boolean isExternallyCancelled() {
            return this.externallyCancelled;
        }

        public void setExternallyCancelled(boolean externallyCancelled) {
            this.externallyCancelled = externallyCancelled;
        }
    }
}

