/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUIType;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.List;

public class BasicVerticalTree
extends InventoryTree {
    private int width;

    public BasicVerticalTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    @Override
    public void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        skills.sort(comparator);
        this.height = 0;
        int size = skills.size();
        for (int i = 0; i < size; ++i) {
            Skill skill = skills.get(i);
            if (skill.getSkillReq() != null) continue;
            if (i == 8) {
                SkillAPI.inst().getLogger().warning(this.getClass().getSimpleName() + " for " + this.tree.getName() + " would be too big and could not be completed. Try changing the tree type of the class.");
                break;
            }
            this.skillSlots.put(i, skill);
            this.width = this.placeChildren(skills, skill, i + 9, 0);
        }
        this.height = Math.max(1, Math.min(SkillAPI.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", this.skillSlots.size() == 0 ? 1 : ((Integer)this.skillSlots.lastKey() + 9) / 9), 6));
    }

    private int placeChildren(List<Skill> skills, Skill skill, int slot, int depth) {
        if (depth + 1 > this.height) {
            this.height = depth + 1;
        }
        int width = 0;
        for (Skill s : skills) {
            if (s.getSkillReq() == null || !s.getSkillReq().equalsIgnoreCase(skill.getName())) continue;
            if ((slot + width) % 9 == 8) {
                SkillAPI.inst().getLogger().warning(this.getClass().getSimpleName() + " for " + this.tree.getName() + " would be too big and could not be completed. Try changing the tree type of the class.");
                break;
            }
            this.skillSlots.put(slot + width, s);
            width += this.placeChildren(skills, s, slot + width + 9, depth + 1);
        }
        return Math.max(width, 1);
    }
}

