/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUIType;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.List;

public class BasicHorizontalTree
extends InventoryTree {
    public BasicHorizontalTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    @Override
    public void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        skills.sort(comparator);
        this.height = 0;
        for (Skill skill : skills) {
            if (skill.getSkillReq() != null) continue;
            this.skillSlots.put(9 * this.height, skill);
            this.height += this.placeChildren(skills, skill, this.height * 9 + 1, 0);
        }
        this.height = Math.max(1, Math.min(SkillAPI.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", this.height), 6));
    }

    private int placeChildren(List<Skill> skills, Skill skill, int slot, int depth) {
        int width = 0;
        for (Skill s : skills) {
            if (s.getSkillReq() == null || !s.getSkillReq().equalsIgnoreCase(skill.getName())) continue;
            if (slot % 9 == 8) {
                SkillAPI.inst().getLogger().warning(this.getClass().getSimpleName() + " for " + this.tree.getName() + " would be too big and could not be completed. Try changing the tree type of the class.");
                break;
            }
            this.skillSlots.put(slot + width * 9, s);
            int w = this.placeChildren(skills, s, slot + width * 9 + 1, depth + 1);
            width += w;
        }
        return Math.max(width, 1);
    }
}

