/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class SkillTree {
    protected final SkillAPI api;
    protected final RPGClass tree;

    public SkillTree(SkillAPI api, RPGClass tree) {
        this.api = api;
        this.tree = tree;
    }

    public boolean canShow(Player player, Skill skill) {
        return (!skill.canAutoLevel(0) || !skill.canAutoLevel(1) || skill.canCast() || SkillAPI.getSettings().isShowingAutoSkills()) && skill.isAllowed(player);
    }

    public void arrange() throws SkillTreeException {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (Skill skill : this.tree.getSkills()) {
            if (!SkillAPI.isSkillRegistered(skill)) {
                Logger.invalid("Failed to add skill to tree - " + skill + ": Skill does not exist");
                continue;
            }
            if (!SkillAPI.getSettings().isShowingAutoSkills() && !skill.canCast() && skill.canAutoLevel(0) && skill.canAutoLevel(1)) continue;
            skills.add(skill);
        }
        this.arrange(skills);
    }

    protected abstract void arrange(List<Skill> var1) throws SkillTreeException;

    public abstract boolean hasSkill(Skill var1);
}

