/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.manager;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.data.Click;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ComboManager {
    private int comboSize = Math.min(SkillAPI.getSettings().getComboSize(), 8);
    private boolean[] clicks = SkillAPI.getSettings().getEnabledClicks();

    public int getComboSize() {
        return this.comboSize;
    }

    public boolean isClickEnabled(int id) {
        return id < this.clicks.length && id >= 0 && this.clicks[id];
    }

    public boolean isValidCombo(int id) {
        if (id <= 0) {
            return false;
        }
        while (id > 0) {
            if (!this.isClickEnabled(0xF & id)) {
                return false;
            }
            id >>= 4;
        }
        return true;
    }

    public boolean isValidDefaultCombo(int id) {
        return this.isValidCombo(id) && id < 1 << 4 * this.comboSize && id >= 1 << 4 * (this.comboSize - 1);
    }

    public List<Click> convertId(int id) {
        ArrayList<Click> clicks = new ArrayList<Click>();
        while (id > 0) {
            Click click = Click.getById(id & 0xF);
            if (click == null) {
                return null;
            }
            clicks.add(click);
            id >>= 4;
        }
        Collections.reverse(clicks);
        return clicks;
    }

    public boolean conflicts(int c1, int c2) {
        c1 = this.reverse(c1);
        for (c2 = this.reverse(c2); c1 > 0 && c2 > 0; c1 >>= 4, c2 >>= 4) {
            if ((c1 & 0xF) == (c2 & 0xF)) continue;
            return false;
        }
        return true;
    }

    public int reverse(int id) {
        int result = 0;
        while (id > 0) {
            result <<= 4;
            result += id & 0xF;
            id >>= 4;
        }
        return result;
    }

    public int convertCombo(Click[] clicks, int amount) {
        int id = 0;
        for (int i = 0; i < clicks.length && i < amount; ++i) {
            id <<= 4;
            id |= clicks[i].getId();
        }
        return id;
    }

    public int convertCombo(Click[] clicks) {
        int id = 0;
        for (Click click : clicks) {
            id <<= 4;
            id |= click.getId();
        }
        return id;
    }

    public int convertCombo(Collection<Click> clicks) {
        return this.convertCombo(clicks.toArray(new Click[clicks.size()]));
    }

    public String getComboString(int combo) {
        if (combo == -1) {
            return "";
        }
        return this.getComboString(this.convertId(combo));
    }

    public String getComboString(List<Click> clicks) {
        if (clicks == null) {
            return "";
        }
        Object result = "";
        for (Click click : clicks) {
            if (((String)result).length() > 0) {
                result = (String)result + ", ";
            }
            result = (String)result + click.getName();
        }
        return result;
    }

    public String getSaveString(int combo) {
        return this.getSaveString(this.convertId(combo));
    }

    public String getSaveString(List<Click> clicks) {
        Object result = "";
        for (Click click : clicks) {
            if (((String)result).length() > 0) {
                result = (String)result + " ";
            }
            result = (String)result + click.getKey();
        }
        return result;
    }

    public int parseCombo(String combo) {
        if (combo == null || combo.length() == 0) {
            return -1;
        }
        String[] parts = combo.toLowerCase().split(" ");
        Click[] clicks = new Click[parts.length];
        int i = 0;
        for (String part : parts) {
            clicks[i] = Click.getByName(part);
            if (clicks[i] == null) {
                Logger.invalid("Invalid combo click type: " + part);
                return -1;
            }
            ++i;
        }
        return this.convertCombo(clicks);
    }
}

