/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.manager;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.data.CustomScoreboardHolder;
import com.sucy.skill.util.PlaceholderUtil;
import mc.promcteam.engine.mccore.chat.Chat;
import mc.promcteam.engine.mccore.chat.Prefix;
import mc.promcteam.engine.mccore.scoreboard.Board;
import mc.promcteam.engine.mccore.scoreboard.BoardManager;
import mc.promcteam.engine.mccore.scoreboard.PlayerBoards;
import mc.promcteam.engine.mccore.scoreboard.StatBoard;
import mc.promcteam.engine.mccore.scoreboard.StatHolder;
import mc.promcteam.engine.mccore.scoreboard.Team;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ClassBoardManager {
    public static void clear(Player player) {
        Chat.getPlayerData((String)player.getName()).clearPluginPrefix("SkillAPI");
        BoardManager.getPlayerBoards((String)player.getName()).removeBoards("SkillAPI");
        BoardManager.clearTeam((String)player.getName());
        BoardManager.clearScore((String)player.getName());
    }

    public static void clearAll() {
        BoardManager.clearPluginBoards((String)"SkillAPI");
    }

    public static void update(PlayerData player, String prefix, ChatColor braceColor) {
        try {
            Chat.getPlayerData((String)player.getPlayerName()).setPluginPrefix(new Prefix("SkillAPI", prefix, braceColor));
            PlayerBoards boards = BoardManager.getPlayerBoards((String)player.getPlayerName());
            boards.removeBoards("SkillAPI");
            BoardManager.clearTeam((String)player.getPlayerName());
            if (SkillAPI.getSettings().isShowScoreboard()) {
                StatBoard board = new StatBoard(PlaceholderUtil.colorizeAndReplace(SkillAPI.getSettings().getScoreboardTitle(), (OfflinePlayer)player.getPlayer()), "SkillAPI");
                CustomScoreboardHolder holder = new CustomScoreboardHolder(player.getPlayer());
                board.addStats((StatHolder)holder);
                boards.addBoard((Board)board);
            }
            if (SkillAPI.getSettings().isShowClassName()) {
                BoardManager.setTeam((String)player.getPlayerName(), (String)player.getMainClass().getData().getName());
            }
            if (SkillAPI.getSettings().isShowClassLevel()) {
                BoardManager.setBelowNameScore((String)player.getPlayerName(), (int)player.getMainClass().getLevel());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void registerClass(RPGClass c) {
        if (SkillAPI.getSettings().isShowClassName()) {
            String name = c.getName();
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            BoardManager.registerTeam((Team)new Team(name, c.getPrefix() + ChatColor.RESET + " ", null));
        }
    }

    public static void updateLevel(PlayerData data) {
        if (SkillAPI.getSettings().isShowClassLevel() && data.hasClass()) {
            BoardManager.setBelowNameScore((String)data.getPlayerName(), (int)data.getMainClass().getLevel());
        }
    }

    public static void registerText() {
        if (SkillAPI.getSettings().isShowClassLevel()) {
            BoardManager.init();
            BoardManager.setTextBelowNames((String)SkillAPI.getSettings().getLevelText());
        }
    }
}

