/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.api.event.FlagApplyEvent;
import com.sucy.skill.api.event.PhysicalDamageEvent;
import com.sucy.skill.api.event.PlayerCastSkillEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.data.TitleType;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.listener.ListenerUtil;
import com.sucy.skill.listener.SkillAPIListener;
import com.sucy.skill.manager.TitleManager;
import java.util.HashMap;
import java.util.HashSet;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class StatusListener
extends SkillAPIListener {
    private static final HashMap<String, Long> messageTimers = new HashMap();
    private static final HashSet<String> interrupts = new HashSet<String>(){
        {
            this.add("stun");
            this.add("silence");
        }
    };
    private static final HashMap<String, String> messageMap = new HashMap<String, String>(){
        {
            this.put("stun", "stunned");
            this.put("root", "rooted");
            this.put("invincible", "invincible");
            this.put("absorb", "absorbed");
            this.put("disarm", "disarmed");
            this.put("silence", "silenced");
            this.put("channeling", "channeling");
            this.put("channel", "channeling");
        }
    };
    private final Vector ZERO = new Vector(0, 0, 0);

    @Override
    public void cleanup() {
        messageTimers.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        FlagManager.clearFlags((LivingEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMove(PlayerMoveEvent event) {
        if ((event.getPlayer().isOnGround() || event.getTo().getY() > event.getFrom().getY()) && this.check((Cancellable)event, (LivingEntity)event.getPlayer(), (LivingEntity)event.getPlayer(), "stun", "root", "channeling")) {
            event.getPlayer().setVelocity(this.ZERO);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInterrupt(FlagApplyEvent event) {
        if (interrupts.contains(event.getFlag()) && FlagManager.hasFlag(event.getEntity(), "channeling")) {
            FlagManager.removeFlag(event.getEntity(), "channeling");
            FlagManager.removeFlag(event.getEntity(), "channel");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlag(FlagApplyEvent event) {
        if ((event.getFlag().equals("stun") || event.getFlag().equals("root") || event.getFlag().equals("channeling")) && !(event.getEntity() instanceof Player)) {
            event.getEntity().addPotionEffect(new PotionEffect(PotionEffectType.SLOW, event.getTicks(), 100));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM) {
            return;
        }
        LivingEntity damager = ListenerUtil.getDamager(event);
        this.check((Cancellable)event, damager, damager, "stun", "disarm");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysicalDamage(PhysicalDamageEvent event) {
        this.check(event, event.getDamager(), event.getDamager(), "channel");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamaged(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || !(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        this.checkAbsorbAndInvincible((LivingEntity)event.getEntity(), (Cancellable)event, event.getDamage());
    }

    public void onTrueDamage(TrueDamageEvent event) {
        this.checkAbsorbAndInvincible(event.getTarget(), event, event.getDamage());
    }

    private void checkAbsorbAndInvincible(LivingEntity entity, Cancellable event, double damage) {
        if (this.check(event, entity, null, "absorb")) {
            VersionManager.heal((LivingEntity)entity, (double)damage);
        } else {
            this.check(event, entity, null, "invincible");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)event.getEntity().getShooter();
            this.check((Cancellable)event, shooter, shooter, "stun", "disarm", "channeling");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCast(PlayerCastSkillEvent event) {
        this.check(event, (LivingEntity)event.getPlayer(), (LivingEntity)event.getPlayer(), "silence", "stun", "channel");
    }

    private boolean checkTime(Player player) {
        if (!messageTimers.containsKey(player.getName()) || System.currentTimeMillis() - messageTimers.get(player.getName()) > 1000L) {
            messageTimers.put(player.getName(), System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private boolean check(Cancellable event, LivingEntity entity, LivingEntity receiver, String ... flags) {
        for (String flag : flags) {
            Player player;
            if (!FlagManager.hasFlag(entity, flag)) continue;
            if (receiver instanceof Player && this.checkTime(player = (Player)receiver)) {
                TitleManager.show(player, TitleType.STATUS, "Status." + messageMap.get(flag), RPGFilter.DURATION.setReplacement("" + FlagManager.getTimeLeft(entity, flag)));
            }
            event.setCancelled(true);
            return true;
        }
        return false;
    }
}

