/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.PlayerClassChangeEvent;
import com.sucy.skill.api.event.PlayerSkillUnlockEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkillSlot;
import com.sucy.skill.listener.MainListener;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CastItemListener
extends SkillAPIListener {
    private final HashMap<UUID, PlayerSkillSlot> data = new HashMap();
    private final Set<UUID> playersDropping = new HashSet<UUID>();

    private void cleanup(Player player) {
        this.data.remove(player.getUniqueId());
        if (SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            player.getInventory().setItem(SkillAPI.getSettings().getCastSlot(), null);
        }
    }

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        MainListener.registerClear(this::handleClear);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.init(player);
        }
    }

    @Override
    public void cleanup() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.cleanup(player);
        }
    }

    @EventHandler
    public void onClassChange(PlayerClassChangeEvent event) {
        this.data.get(event.getPlayerData().getPlayer().getUniqueId()).init(event.getPlayerData());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChangePre(PlayerChangedWorldEvent event) {
        boolean from = SkillAPI.getSettings().isWorldEnabled(event.getFrom());
        boolean to = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (from && !to) {
            event.getPlayer().getInventory().setItem(SkillAPI.getSettings().getCastSlot(), null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        boolean from = SkillAPI.getSettings().isWorldEnabled(event.getFrom());
        boolean to = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (to && !from) {
            this.init(event.getPlayer());
        }
    }

    private PlayerSkillSlot get(Player player) {
        return this.data.get(player.getUniqueId());
    }

    private PlayerSkillSlot get(PlayerData data) {
        return this.data.get(data.getPlayer().getUniqueId());
    }

    private void init(Player player) {
        if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        PlayerSkillSlot slotData = new PlayerSkillSlot();
        this.data.put(player.getUniqueId(), slotData);
        slotData.init(SkillAPI.getPlayerData((OfflinePlayer)player));
        PlayerInventory inv = player.getInventory();
        int slot = SkillAPI.getSettings().getCastSlot();
        ItemStack item = inv.getItem(slot);
        slotData.updateItem(player);
        if (item != null && item.getType() != Material.AIR) {
            inv.addItem(new ItemStack[]{item});
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.cleanup(event.getPlayer());
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        this.get(event.getPlayerData()).unlock(event.getUnlockedSkill());
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getWhoClicked().getWorld())) {
            if (event.getSlot() == SkillAPI.getSettings().getCastSlot() && event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                event.setCancelled(true);
            } else if (event.getAction() == InventoryAction.HOTBAR_SWAP && event.getHotbarButton() == SkillAPI.getSettings().getCastSlot()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDrop(final PlayerDropItemEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld()) && event.getPlayer().getInventory().getHeldItemSlot() == SkillAPI.getSettings().getCastSlot()) {
            event.setCancelled(true);
            this.get(event.getPlayer()).activate();
            this.playersDropping.add(event.getPlayer().getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    CastItemListener.this.playersDropping.remove(event.getPlayer().getUniqueId());
                }
            }.runTask((Plugin)SkillAPI.inst());
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            event.getDrops().remove(event.getEntity().getInventory().getItem(SkillAPI.getSettings().getCastSlot()));
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld()) && event.getPlayer().getInventory().getHeldItemSlot() == SkillAPI.getSettings().getCastSlot()) {
            event.setCancelled(true);
            if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (this.playersDropping.remove(event.getPlayer().getUniqueId())) {
                    return;
                }
                this.get(event.getPlayer()).prev();
            } else if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                this.get(event.getPlayer()).next();
            }
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        this.data.get(event.getPlayer().getUniqueId()).setHovering(event.getNewSlot() == SkillAPI.getSettings().getCastSlot());
    }

    private void handleClear(Player player) {
        player.getInventory().setItem(SkillAPI.getSettings().getCastSlot(), SkillAPI.getSettings().getCastItem());
    }
}

