/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.api.event.BuffExpiredEvent;
import com.sucy.skill.api.event.PhysicalDamageEvent;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.api.event.SkillHealEvent;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.BuffType;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.listener.PacketListener;
import com.sucy.skill.listener.SkillAPIListener;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffectType;

public class BuffListener
extends SkillAPIListener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPhysical(PhysicalDamageEvent event) {
        double withDamageBuffs = BuffManager.apply(event.getDamager(), BuffType.DAMAGE, event.getDamage());
        double withDefenseBuffs = BuffManager.apply(event.getTarget(), BuffType.DEFENSE, withDamageBuffs);
        event.setDamage(withDefenseBuffs);
        if (withDefenseBuffs <= 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSkill(SkillDamageEvent event) {
        if (event.getClassification().equalsIgnoreCase("physical")) {
            double withDamageBuffs = BuffManager.apply(event.getDamager(), BuffType.DAMAGE, event.getDamage());
            double withDefenseBuffs = BuffManager.apply(event.getTarget(), BuffType.DEFENSE, withDamageBuffs);
            event.setDamage(withDefenseBuffs);
            if (withDefenseBuffs <= 0.0) {
                event.setCancelled(true);
            }
        } else {
            double withDamageBuffs = BuffManager.apply(event.getDamager(), BuffType.SKILL_DAMAGE, event.getClassification(), event.getDamage());
            double withDefenseBuffs = BuffManager.apply(event.getTarget(), BuffType.SKILL_DEFENSE, event.getClassification(), withDamageBuffs);
            event.setDamage(withDefenseBuffs);
            if (withDefenseBuffs <= 0.0) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHeal(SkillHealEvent event) {
        double withBuff = BuffManager.apply(event.getTarget(), BuffType.HEALING, event.getAmount());
        event.setAmount(withBuff);
        if (withBuff <= 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBuffExpire(BuffExpiredEvent event) {
        if (event.getType().equals((Object)BuffType.INVISIBILITY) && PluginChecker.isProtocolLibActive()) {
            PacketListener.updateEquipment((Player)event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEffectExpire(EntityPotionEffectEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getModifiedType().equals((Object)PotionEffectType.INVISIBILITY)) {
            return;
        }
        if (event.getAction().equals((Object)EntityPotionEffectEvent.Action.CLEARED) || event.getAction().equals((Object)EntityPotionEffectEvent.Action.REMOVED)) {
            BuffManager.getBuffData((LivingEntity)event.getEntity()).clearByType(BuffType.INVISIBILITY);
            if (PluginChecker.isProtocolLibActive()) {
                PacketListener.updateEquipment((Player)event.getEntity());
            }
        }
    }
}

