/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook.mimic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.hook.mimic.ProSkillApiConverter;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.endlesscode.mimic.level.BukkitLevelSystem;
import ru.endlesscode.mimic.level.ExpLevelConverter;

public class ProSkillApiLevelSystem
extends BukkitLevelSystem {
    public ProSkillApiLevelSystem(@NotNull Player player) {
        super(player);
    }

    @NotNull
    public ExpLevelConverter getConverter() {
        return ProSkillApiConverter.getInstance();
    }

    public int getLevel() {
        PlayerClass playerClass = this.getPlayerClass();
        return playerClass != null ? playerClass.getLevel() : 1;
    }

    public void setLevel(int level) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            playerClass.setLevel(level);
        }
    }

    public double getExp() {
        PlayerClass playerClass = this.getPlayerClass();
        return playerClass != null ? playerClass.getExp() : 0.0;
    }

    public void setExp(double exp) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            playerClass.setExp(exp);
        }
    }

    public void takeLevels(int lvlAmount) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            int newLevel = Math.max(this.getLevel() - lvlAmount, 1);
            double fractionalExp = this.getFractionalExp();
            this.setLevel(newLevel);
            this.setFractionalExp(fractionalExp);
        }
    }

    public void giveLevels(int lvlAmount) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            playerClass.giveLevels(lvlAmount);
        }
    }

    public void takeExp(double expAmount) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            double percent = expAmount / (double)playerClass.getRequiredExp();
            playerClass.loseExp(percent);
        }
    }

    public void giveExp(double expAmount) {
        PlayerClass playerClass = this.getPlayerClass();
        if (playerClass != null) {
            playerClass.giveExp(expAmount, ExpSource.SPECIAL);
        }
    }

    @Nullable
    private PlayerClass getPlayerClass() {
        return SkillAPI.getPlayerData((OfflinePlayer)this.getPlayer()).getMainClass();
    }
}

