/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.sucy.skill.SkillAPI;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtocolLibHook {
    private final SkillAPI plugin;
    private final ProtocolManager protocolManager;

    public ProtocolLibHook(SkillAPI plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public void register(PacketAdapter listener) {
        this.protocolManager.addPacketListener((PacketListener)listener);
    }

    public void unregister() {
        this.protocolManager.removePacketListeners((Plugin)this.plugin);
    }

    public void unregister(PacketAdapter listener) {
        this.protocolManager.removePacketListener((PacketListener)listener);
    }

    public void unregister(Iterable<PacketAdapter> listeners) {
        listeners.forEach(c -> this.unregister((PacketAdapter)c));
    }

    public void broadcastToNearby(Player player, PacketContainer packet) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            double dist;
            if (player.equals(p) || !p.getWorld().equals(player.getWorld()) || !((dist = player.getLocation().distanceSquared(p.getLocation())) < (double)(Bukkit.getViewDistance() * 16))) continue;
            try {
                this.protocolManager.sendServerPacket(p, packet);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

