/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook;

import com.sucy.skill.hook.VaultHook;
import com.sucy.skill.hook.mimic.MimicHook;
import com.sucy.skill.listener.SkillAPIListener;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PluginChecker
extends SkillAPIListener {
    private static boolean vault;
    private static boolean libsDisguises;
    private static boolean noCheatPlus;
    private static boolean papi;
    private static boolean bungee;
    private static boolean mythicMobs;
    private static boolean worldGuard;
    private static boolean parties;
    private static boolean mimic;
    private static boolean protocolLib;

    public static boolean isVaultPermissionsActive() {
        return vault && VaultHook.isPermissionsValid();
    }

    public static boolean isVaultEconomyActive() {
        return vault && VaultHook.isEconomyValid();
    }

    public static boolean isDisguiseActive() {
        return libsDisguises;
    }

    public static boolean isNoCheatActive() {
        return noCheatPlus;
    }

    public static boolean isPlaceholderAPIActive() {
        return papi;
    }

    public static boolean isBungeeActive() {
        return bungee;
    }

    public static boolean isMythicMobsActive() {
        return mythicMobs;
    }

    public static boolean isWorldGuardActive() {
        return worldGuard;
    }

    public static boolean isProtocolLibActive() {
        return protocolLib;
    }

    public static boolean isPartiesActive() {
        return parties || Bukkit.getPluginManager().isPluginEnabled("ProSkillAPIParties");
    }

    public static boolean isMimicActive() {
        return mimic && MimicHook.isHooked();
    }

    @Override
    public void init() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        vault = pluginManager.isPluginEnabled("Vault");
        libsDisguises = pluginManager.isPluginEnabled("LibsDisguises");
        noCheatPlus = pluginManager.isPluginEnabled("NoCheatPlus");
        papi = pluginManager.isPluginEnabled("PlaceholderAPI");
        try {
            Class.forName("net.md_5.bungee.Util");
            bungee = true;
        }
        catch (Exception ex) {
            bungee = false;
        }
        mythicMobs = pluginManager.isPluginEnabled("MythicMobs");
        worldGuard = pluginManager.isPluginEnabled("WorldGuard");
        parties = pluginManager.isPluginEnabled("ProSkillAPIParties");
        mimic = pluginManager.isPluginEnabled("Mimic");
        protocolLib = pluginManager.isPluginEnabled("ProtocolLib");
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.onPluginToggled(event.getPlugin(), true);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        this.onPluginToggled(event.getPlugin(), false);
    }

    private void onPluginToggled(Plugin plugin, Boolean isEnabled) {
        switch (plugin.getName()) {
            case "Vault": {
                vault = isEnabled;
                break;
            }
            case "LibsDisguises": {
                libsDisguises = isEnabled;
                break;
            }
            case "NoCheatPlus": {
                noCheatPlus = isEnabled;
                break;
            }
            case "PlaceholderAPI": {
                papi = isEnabled;
                break;
            }
            case "MythicMobs": {
                mythicMobs = isEnabled;
                break;
            }
            case "WorldGuard": {
                worldGuard = isEnabled;
                break;
            }
            case "ProSkillAPIParties": {
                parties = isEnabled;
                break;
            }
            case "Mimic": {
                mimic = isEnabled;
                break;
            }
            case "ProtocolLib": {
                protocolLib = isEnabled;
            }
        }
    }
}

