/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook;

import com.sucy.skill.util.PlaceholderUtil;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    public boolean persist() {
        return true;
    }

    public static String format(String message, Player player) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
    }

    public static ItemStack processPlaceholders(ItemStack item, Player player) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (meta.hasDisplayName()) {
            meta.setDisplayName(PlaceholderAPIHook.format(meta.getDisplayName(), player));
        }
        if (meta.hasLore()) {
            List lore = meta.getLore().stream().map(line -> PlaceholderAPIHook.format(line, player)).collect(Collectors.toList());
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "Spark";
    }

    public String getIdentifier() {
        return "sapi";
    }

    public String getVersion() {
        return "1.0.1";
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        identifier = PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, (String)identifier);
        return PlaceholderUtil.replace(player, identifier);
    }
}

