/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.trigger;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.util.List;

public abstract class SkillTrigger
implements Trigger<SkillDamageEvent> {
    @Override
    public Class<SkillDamageEvent> getEvent() {
        return SkillDamageEvent.class;
    }

    @Override
    public boolean shouldTrigger(SkillDamageEvent event, int level, Settings settings) {
        double min = settings.getDouble("dmg-min");
        double max = settings.getDouble("dmg-max");
        List<String> types = settings.getStringList("category");
        boolean empty = types.isEmpty() || types.get(0).isEmpty();
        return event.getDamage() >= min && event.getDamage() <= max && (empty || types.contains(event.getClassification()));
    }

    @Override
    public void postProcess(SkillDamageEvent event, DynamicSkill skill) {
        double damage = skill.applyImmediateBuff(event.getDamage());
        event.setDamage(damage);
    }

    boolean isUsingTarget(Settings settings) {
        return settings.getString("target", "true").equalsIgnoreCase("false");
    }
}

