/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.trigger;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.PlayerCastSkillEvent;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;

public class SkillCastTrigger
implements Trigger<PlayerCastSkillEvent> {
    @Override
    public String getKey() {
        return "SKILL_CAST";
    }

    @Override
    public Class<PlayerCastSkillEvent> getEvent() {
        return PlayerCastSkillEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerCastSkillEvent event, int level, Settings settings) {
        List classes = settings.getStringList("allowed-classes").stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        List skills = settings.getStringList("allowed-skills").stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        List blackClasses = classes.stream().filter(c -> c.startsWith("!")).map(c -> c.substring(1)).collect(Collectors.toList());
        List blackSkills = skills.stream().filter(c -> c.startsWith("!")).map(c -> c.substring(1)).collect(Collectors.toList());
        classes = classes.stream().filter(c -> !c.startsWith("!")).collect(Collectors.toList());
        skills = skills.stream().filter(c -> !c.startsWith("!")).collect(Collectors.toList());
        String skillName = event.getSkill().getData().getName();
        String className = event.getPlayerData().getMainClass().getData().getName();
        if (!skills.isEmpty() && !skills.contains(skillName) || blackSkills.contains(skillName)) {
            return false;
        }
        if (!classes.isEmpty() && !classes.contains(className) || blackClasses.contains(className)) {
            return false;
        }
        boolean cancelEvent = settings.getBool("cancel");
        if (cancelEvent) {
            event.setCancelled(true);
        }
        return true;
    }

    @Override
    public void setValues(PlayerCastSkillEvent event, Map<String, Object> data) {
        data.put("api-skill", event.getSkill().getData().getName());
        data.put("api-mana", event.getManaCost());
    }

    @Override
    public LivingEntity getCaster(PlayerCastSkillEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerCastSkillEvent event, Settings settings) {
        return event.getPlayer();
    }
}

