/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.trigger;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.PlayerBlockDamageEvent;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.util.Map;
import org.bukkit.entity.LivingEntity;

public class ShieldTrigger
implements Trigger<PlayerBlockDamageEvent> {
    @Override
    public String getKey() {
        return "SHIELD";
    }

    @Override
    public Class<PlayerBlockDamageEvent> getEvent() {
        return PlayerBlockDamageEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerBlockDamageEvent event, int level, Settings settings) {
        String type = settings.getString("type", "Both").toLowerCase();
        if (!type.equals("both") && !type.equals(event.getType())) {
            return false;
        }
        double min = settings.getDouble("dmg-min", 0.0);
        double max = settings.getDouble("dmg-max", 9999.0);
        return event.getDamage() >= min && event.getDamage() <= max;
    }

    @Override
    public void setValues(PlayerBlockDamageEvent event, Map<String, Object> data) {
        data.put("api-blocked", event.getDamage());
    }

    @Override
    public LivingEntity getCaster(PlayerBlockDamageEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerBlockDamageEvent event, Settings settings) {
        return settings.getBool("target", false) ? event.getPlayer() : (LivingEntity)event.getSource();
    }
}

