/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.trigger;

import com.sucy.skill.api.Settings;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.block.BlockBreakEvent;

public class BlockBreakTrigger
implements Trigger<BlockBreakEvent> {
    @Override
    public String getKey() {
        return "BLOCK_BREAK";
    }

    @Override
    public Class<BlockBreakEvent> getEvent() {
        return BlockBreakEvent.class;
    }

    @Override
    public boolean shouldTrigger(BlockBreakEvent event, int level, Settings settings) {
        List<String> types = settings.getStringList("material");
        return types.isEmpty() || types.contains("Any") || types.stream().anyMatch(mat -> event.getBlock().getType().name().equalsIgnoreCase(mat.replace(' ', '_')));
    }

    @Override
    public void setValues(BlockBreakEvent event, Map<String, Object> data) {
        data.put("api-block-type", event.getBlock().getType().name());
        data.put("api-block-loc", event.getBlock().getLocation());
    }

    @Override
    public LivingEntity getCaster(BlockBreakEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(BlockBreakEvent event, Settings settings) {
        return event.getPlayer();
    }
}

