/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.google.common.collect.ImmutableList;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class SingleTarget
extends TargetComponent {
    private static final String RANGE = "range";
    private static final String TOLERANCE = "tolerance";

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 5.0);
        double tolerance = this.parseValues(caster, TOLERANCE, level, 4.0);
        return this.determineTargets(caster, level, targets, t -> {
            LivingEntity target = TargetHelper.getLivingTarget(t, range, tolerance);
            return target == null ? ImmutableList.of() : ImmutableList.of((Object)target);
        });
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        BukkitTask task;
        super.playPreview(onPreviewStop, caster, level, targetSupplier);
        if (this.preview.getBool("line", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(SingleTarget.this.preview, "line-");
                    double range = SingleTarget.this.parseValues((LivingEntity)caster, SingleTarget.RANGE, level, 5.0);
                    double density = SingleTarget.this.preview.getDouble("line-density", 1.0);
                    double rStep = 1.0 / range / density;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation();
                        Vector direction = origin.getDirection();
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = SingleTarget.this.preview.getDouble("line-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            particleSettings.instance(caster, origin.getX(), origin.getY(), origin.getZ());
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("line-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        if (this.preview.getBool("cylinder", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(SingleTarget.this.preview, "cylinder-");
                    double range = SingleTarget.this.parseValues((LivingEntity)caster, SingleTarget.RANGE, level, 5.0);
                    double radius = SingleTarget.this.parseValues((LivingEntity)caster, SingleTarget.TOLERANCE, level, 0.0);
                    double density = SingleTarget.this.preview.getDouble("cylinder-density", 1.0);
                    double rStep = 1.0 / range / density;
                    double angleStep = 1.0 / radius / density;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation();
                        Vector direction = origin.getDirection();
                        Location altDirection = origin.clone();
                        altDirection.setPitch((origin.getPitch() + 135.0f) % 180.0f - 90.0f);
                        Vector radiusVec = altDirection.getDirection().crossProduct(direction).multiply(radius);
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = SingleTarget.this.preview.getDouble("cylinder-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            for (double totalAngle = 0.0; totalAngle <= 3.241592653589793; totalAngle += angleStep) {
                                Vector vector = radiusVec.clone().rotateAroundNonUnitAxis(direction, totalAngle);
                                particleSettings.instance(caster, origin.getX() + vector.getX(), origin.getY() + vector.getY(), origin.getZ() + vector.getZ());
                                particleSettings.instance(caster, origin.getX() - vector.getX(), origin.getY() - vector.getY(), origin.getZ() - vector.getZ());
                            }
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("cylinder-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }

    @Override
    public String getKey() {
        return "single";
    }
}

