/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.google.common.collect.ImmutableList;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class OffsetTarget
extends TargetComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String HORIZONTAL = "horizontal";

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        return this.determineTargets(caster, level, targets, t -> ImmutableList.of((Object)this.getTargetLoc(caster, level, (LivingEntity)t)));
    }

    private TempEntity getTargetLoc(LivingEntity caster, int level, LivingEntity t) {
        boolean horizontal = this.settings.getBool(HORIZONTAL, false);
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        Vector dir = t.getLocation().getDirection().setY(0).normalize();
        if (horizontal) {
            dir.setY(0).normalize();
        }
        Vector nor = dir.clone().crossProduct(UP);
        dir.multiply(forward);
        dir.add(nor.multiply(right)).setY(upward);
        return new TempEntity(t.getLocation().add(dir));
    }

    @Override
    public String getKey() {
        return "offset";
    }
}

