/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ConeTarget
extends TargetComponent {
    private static final String ANGLE = "angle";
    private static final String RANGE = "range";

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        BukkitTask task;
        super.playPreview(onPreviewStop, caster, level, targetSupplier);
        if (this.preview.getBool("triangle", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(ConeTarget.this.preview, "triangle-");
                    double angle = ConeTarget.this.parseValues((LivingEntity)caster, ConeTarget.ANGLE, level, 90.0) * Math.PI / 360.0;
                    double range = ConeTarget.this.parseValues((LivingEntity)caster, ConeTarget.RANGE, level, 5.0);
                    double density = ConeTarget.this.preview.getDouble("triangle-density", 1.0);
                    double rStep = 1.0 / range / density;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation();
                        Vector direction = origin.getDirection();
                        Location altDirection = origin.clone();
                        altDirection.setPitch((origin.getPitch() + 135.0f) % 180.0f - 90.0f);
                        Vector perpendicular = altDirection.getDirection().crossProduct(direction);
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = ConeTarget.this.preview.getDouble("triangle-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            double radius = rLocation * Math.tan(angle);
                            Vector vector = perpendicular.clone().multiply(radius);
                            particleSettings.instance(caster, origin.getX() + vector.getX(), origin.getY() + vector.getY(), origin.getZ() + vector.getZ());
                            particleSettings.instance(caster, origin.getX() - vector.getX(), origin.getY() - vector.getY(), origin.getZ() - vector.getZ());
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("triangle-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        if (this.preview.getBool("cone", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(ConeTarget.this.preview, "cone-");
                    double angle = ConeTarget.this.parseValues((LivingEntity)caster, ConeTarget.ANGLE, level, 90.0) * Math.PI / 360.0;
                    double range = ConeTarget.this.parseValues((LivingEntity)caster, ConeTarget.RANGE, level, 5.0);
                    double density = ConeTarget.this.preview.getDouble("cone-density", 1.0);
                    double rStep = 1.0 / range / density;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation();
                        Vector direction = origin.getDirection();
                        Location altDirection = origin.clone();
                        altDirection.setPitch((origin.getPitch() + 135.0f) % 180.0f - 90.0f);
                        Vector perpendicular = altDirection.getDirection().crossProduct(direction);
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = ConeTarget.this.preview.getDouble("cone-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            double radius = rLocation * Math.tan(angle);
                            Vector radiusVec = perpendicular.clone().multiply(radius);
                            double angleStep = 1.0 / radius / density;
                            for (double totalAngle = 0.0; totalAngle <= 3.241592653589793; totalAngle += angleStep) {
                                Vector vector = radiusVec.clone().rotateAroundNonUnitAxis(direction, totalAngle);
                                particleSettings.instance(caster, origin.getX() + vector.getX(), origin.getY() + vector.getY(), origin.getZ() + vector.getZ());
                                particleSettings.instance(caster, origin.getX() - vector.getX(), origin.getY() - vector.getY(), origin.getZ() - vector.getZ());
                            }
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("cone-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 3.0);
        double angle = this.parseValues(caster, ANGLE, level, 90.0);
        return this.determineTargets(caster, level, targets, t -> TargetHelper.getConeTargets(t, angle, range));
    }

    @Override
    public String getKey() {
        return "cone";
    }
}

