/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;

public class WarpRandomMechanic
extends MechanicComponent {
    private static final String WALL = "walls";
    private static final String HORIZONTAL = "horizontal";
    private static final String DISTANCE = "distance";

    @Override
    public String getKey() {
        return "warp random";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        boolean throughWalls = this.settings.getString(WALL, "false").toLowerCase().equals("true");
        boolean horizontal = !this.settings.getString(HORIZONTAL, "true").toLowerCase().equals("false");
        double distance = this.parseValues(caster, DISTANCE, level, 3.0);
        for (LivingEntity target : targets) {
            Location loc;
            Location temp = target.getLocation();
            do {
                loc = temp.clone().add(this.rand(distance), 0.0, this.rand(distance));
                if (horizontal) continue;
                loc.add(0.0, this.rand(distance), 0.0);
            } while (temp.distanceSquared(loc) > distance * distance);
            loc = TargetHelper.getOpenLocation(target.getLocation().add(0.0, 1.0, 0.0), loc, throughWalls);
            if (!loc.getBlock().getType().isSolid() && loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                loc.add(0.0, 1.0, 0.0);
            }
            target.teleport(loc.subtract(0.0, 1.0, 0.0));
        }
        return targets.size() > 0;
    }

    private double rand(double distance) {
        return SkillAPI.RANDOM.nextDouble() * distance * 2.0 - distance;
    }
}

