/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class WarpMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String WALL = "walls";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";

    @Override
    public String getKey() {
        return "warp";
    }

    private Location getLocation(LivingEntity caster, int level, LivingEntity target) {
        boolean throughWalls = this.settings.getString(WALL, "false").toLowerCase().equals("true");
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        Vector dir = target.getLocation().getDirection();
        Vector side = dir.clone().crossProduct(UP).multiply(right);
        Location loc = target.getLocation().add(dir.multiply(forward)).add(side).add(0.0, upward, 0.0).add(0.0, 1.0, 0.0);
        loc = TargetHelper.getOpenLocation(target.getLocation().add(0.0, 1.0, 0.0), loc, throughWalls);
        if (!loc.getBlock().getType().isSolid() && loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
            loc.add(0.0, 1.0, 0.0);
        }
        return loc.subtract(0.0, 1.0, 0.0);
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        for (LivingEntity target : targets) {
            target.teleport(this.getLocation(caster, level, target));
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        ParticleHelper.play(WarpMechanic.this.getLocation((LivingEntity)caster, level, target), WarpMechanic.this.preview, Set.of(caster), "per-target-", WarpMechanic.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

