/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.PlaceholderAPIHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.log.Logger;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ValuePlaceholderMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String PLACEHOLDER = "placeholder";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value placeholder";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY);
        String placeholder = this.settings.getString(PLACEHOLDER);
        String type = this.settings.getString(TYPE).toUpperCase();
        String value = placeholder;
        if (PluginChecker.isPlaceholderAPIActive() && targets.get(0) instanceof Player) {
            value = PlaceholderAPIHook.format(placeholder, (Player)targets.get(0));
        }
        switch (type.charAt(0)) {
            case 'S': {
                DynamicSkill.getCastData(caster).put(key, value);
                break;
            }
            default: {
                try {
                    DynamicSkill.getCastData(caster).put(key, Double.parseDouble(value));
                    break;
                }
                catch (Exception ex) {
                    Logger.invalid(placeholder + " is not a valid numeric placeholder - PlaceholderAPI returned " + value);
                    return false;
                }
            }
        }
        if (this.settings.getBool(SAVE, false)) {
            SkillAPI.getPlayerData((OfflinePlayer)caster).setPersistentData(key, DynamicSkill.getCastData(caster).get(key));
        }
        return true;
    }
}

