/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ValueManaMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value mana";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(targets.get(0) instanceof Player)) {
            return false;
        }
        PlayerData player = SkillAPI.getPlayerData((OfflinePlayer)((Player)targets.get(0)));
        String key = this.settings.getString(KEY);
        String type = this.settings.getString(TYPE, "current").toLowerCase();
        Map<String, Object> data = DynamicSkill.getCastData(caster);
        switch (type) {
            case "max": {
                data.put(key, player.getMaxMana());
            }
            case "percent": {
                data.put(key, player.getMana() / player.getMaxMana());
            }
            case "missing": {
                data.put(key, player.getMaxMana() - player.getMana());
            }
        }
        data.put(key, player.getMana());
        if (this.settings.getBool(SAVE, false)) {
            SkillAPI.getPlayerData((OfflinePlayer)caster).setPersistentData(key, data.get(key));
        }
        return true;
    }
}

