/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;

public class ValueAddMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String AMOUNT = "amount";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value add";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        double amount = this.parseValues(caster, AMOUNT, level, 1.0) * (double)targets.size();
        Map<String, Object> data = DynamicSkill.getCastData(caster);
        if (!data.containsKey(key)) {
            data.put(key, amount);
        } else {
            data.put(key, amount + (Double)data.get(key));
        }
        if (this.settings.getBool(SAVE, false)) {
            SkillAPI.getPlayerData((OfflinePlayer)caster).setPersistentData(key, data.get(key));
        }
        return true;
    }
}

