/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.MythicMobsHook;
import com.sucy.skill.hook.PluginChecker;
import java.util.List;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;

public class TauntMechanic
extends MechanicComponent {
    private static final String AMOUNT = "amount";

    @Override
    public String getKey() {
        return "taunt";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        double amount = this.parseValues(caster, AMOUNT, level, 1.0);
        boolean taunted = false;
        for (LivingEntity entity : targets) {
            if (!(entity instanceof Creature) || entity == caster) continue;
            if (PluginChecker.isMythicMobsActive() && MythicMobsHook.isMonster(entity)) {
                MythicMobsHook.taunt(entity, caster, amount);
            } else {
                ((Creature)entity).setTarget(caster);
            }
            taunted = true;
        }
        return taunted;
    }
}

