/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.log.Logger;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;

public class SoundMechanic
extends MechanicComponent {
    private static final String SOUND = "sound";
    private static final String SOUND2 = "newsound";
    private static final String CUSTOM = "custom";
    private static final String VOLUME = "volume";
    private static final String PITCH = "pitch";

    @Override
    public String getKey() {
        return SOUND;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        String type = this.settings.getString(SOUND, this.settings.getString(SOUND2, "")).toUpperCase().replace(" ", "_");
        try {
            String sound = type.equals("CUSTOM") ? this.settings.getString(CUSTOM, "") : Sound.valueOf((String)type).getKey().toString();
            float volume = (float)this.parseValues(caster, VOLUME, level, 100.0) / 100.0f;
            float pitch = (float)this.parseValues(caster, PITCH, level, 0.0);
            volume = Math.max(0.0f, volume);
            pitch = Math.min(2.0f, Math.max(0.5f, pitch));
            for (LivingEntity target : targets) {
                target.getWorld().playSound(target.getLocation(), sound, volume, pitch);
            }
            return targets.size() > 0;
        }
        catch (Exception ex) {
            Logger.invalid("Invalid sound type: " + type);
            return false;
        }
    }
}

