/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.event.SignalEmitEvent;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class SignalEmitMechanic
extends MechanicComponent {
    private static final String SIGNAL = "signal";
    private static final String ARGUMENT = "argument";
    private static final String HANDLER = "handler";

    @Override
    public String getKey() {
        return "signal emit";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String signal = this.settings.getString(SIGNAL);
        List<String> arguments = this.settings.getStringList(ARGUMENT);
        boolean selfHandling = this.settings.getBool(HANDLER);
        targets.forEach(target -> {
            List<Object> filtered = arguments.parallelStream().map(arg -> {
                Object value = DynamicSkill.getCastData(caster).get(arg);
                return value == null ? this.filter(caster, (LivingEntity)target, (String)arg) : value;
            }).collect(Collectors.toList());
            Bukkit.getPluginManager().callEvent((Event)new SignalEmitEvent(this.skill, caster, (LivingEntity)target, signal, filtered, selfHandling));
        });
        return true;
    }
}

