/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.EffectPlayer;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.api.particle.target.EntityTarget;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ParticleProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.task.RemoveTask;
import com.sucy.skill.task.RepeatingEntityTask;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ProjectileMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String PROJECTILE = "projectile";
    private static final String FLAMING = "flaming";
    private static final String COST = "cost";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    private static final HashMap<String, Class<? extends Projectile>> PROJECTILES = new HashMap<String, Class<? extends Projectile>>(){
        {
            this.put("arrow", Arrow.class);
            this.put("egg", Egg.class);
            this.put("ghast fireball", LargeFireball.class);
            this.put("snowball", Snowball.class);
        }
    };
    private static final HashMap<String, Material> MATERIALS = new HashMap<String, Material>(){
        {
            this.put("arrow", Material.ARROW);
            this.put("egg", Material.EGG);
            this.put("snowball", ProjectileMechanic.snowBall());
        }
    };
    private static final Class<Enum<?>> PICKUP_STATUS_ENUM = null;

    private static Class<? extends Projectile> getProjectileClass(String projectileName) {
        StringBuilder conditionedName = new StringBuilder();
        for (String word : projectileName.split(" ")) {
            conditionedName.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        try {
            return Class.forName("org.bukkit.entity." + conditionedName);
        }
        catch (ClassNotFoundException e) {
            return PROJECTILES.get(projectileName);
        }
    }

    private static Material snowBall() {
        for (Material material : Material.values()) {
            if (!material.name().startsWith("SNOW") || !material.name().endsWith("BALL")) continue;
            return material;
        }
        return Material.SNOW;
    }

    @Override
    public String getKey() {
        return PROJECTILE;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        Object player;
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        double speed = this.parseValues(caster, VELOCITY, level, 2.0);
        boolean flaming = this.settings.getString(FLAMING, "false").equalsIgnoreCase("true");
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        String projectile = this.settings.getString(PROJECTILE, "arrow").toLowerCase();
        String cost = this.settings.getString(COST, "none").toLowerCase();
        Class<? extends Projectile> type = ProjectileMechanic.getProjectileClass(projectile);
        if (type == null) {
            type = Arrow.class;
        }
        if (cost.equals("one") || cost.equals("all")) {
            Material mat = MATERIALS.get(this.settings.getString(PROJECTILE, "arrow").toLowerCase());
            if (mat == null || !(caster instanceof Player)) {
                return false;
            }
            player = (Player)caster;
            if (cost.equals("one") && !player.getInventory().contains(mat, 1)) {
                return false;
            }
            if (cost.equals("all") && !player.getInventory().contains(mat, amount)) {
                return false;
            }
            if (cost.equals("one")) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(mat)});
            } else {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(mat, amount)});
            }
        }
        final ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        for (LivingEntity target : targets) {
            if (spread.equals("rain")) {
                double radius = this.parseValues(caster, RADIUS, level, 2.0);
                double height = this.parseValues(caster, HEIGHT, level, 8.0);
                ArrayList<Location> locs = CustomProjectile.calcRain(target.getLocation(), radius, height, amount);
                for (Location loc : locs) {
                    Projectile p = caster.launchProjectile(type);
                    p.setTicksLived(1180);
                    if (type.getName().contains("Arrow")) {
                        try {
                            try {
                                AbstractArrow arrow = (AbstractArrow)p;
                                arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                            }
                            catch (NoClassDefFoundError e) {
                                Arrow arrow = (Arrow)p;
                                Class<?> pickupStatusClass = Class.forName("org.bukkit.Arrow$PickupStatus");
                                Arrow.class.getMethod("setPickupStatus", pickupStatusClass).invoke((Object)arrow, pickupStatusClass.getMethod("valueOf", String.class).invoke(null, "DISALLOWED"));
                            }
                        }
                        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodError | NoSuchMethodException | InvocationTargetException throwable) {
                            // empty catch block
                        }
                    }
                    p.setVelocity(new Vector(0.0, speed, 0.0));
                    p.teleport(loc);
                    SkillAPI.setMeta((Metadatable)p, LEVEL, level);
                    if (flaming) {
                        p.setFireTicks(Integer.MAX_VALUE);
                    }
                    projectiles.add(p);
                }
                continue;
            }
            Vector dir = target.getLocation().getDirection();
            if (spread.equals("horizontal cone")) {
                dir.setY(0);
                dir.normalize();
            }
            double angle = this.parseValues(caster, ANGLE, level, 30.0);
            double right = this.parseValues(caster, RIGHT, level, 0.0);
            double upward = this.parseValues(caster, UPWARD, level, 0.0);
            double forward = this.parseValues(caster, FORWARD, level, 0.0);
            Vector looking = target.getLocation().getDirection().setY(0).normalize();
            Vector normal = looking.clone().crossProduct(UP);
            looking.multiply(forward).add(normal.multiply(right));
            ArrayList<Vector> dirs = CustomProjectile.calcSpread(dir, angle, amount);
            for (Vector d : dirs) {
                Projectile p = caster.launchProjectile(type);
                if (type.getName().contains("Arrow")) {
                    try {
                        try {
                            AbstractArrow arrow = (AbstractArrow)p;
                            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                        }
                        catch (NoClassDefFoundError e) {
                            Arrow arrow = (Arrow)p;
                            Class<?> pickupStatusClass = Class.forName("org.bukkit.Arrow$PickupStatus");
                            Arrow.class.getMethod("setPickupStatus", pickupStatusClass).invoke((Object)arrow, pickupStatusClass.getMethod("valueOf", String.class).invoke(null, "DISALLOWED"));
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodError | NoSuchMethodException | InvocationTargetException throwable) {}
                } else {
                    p.teleport(target.getLocation().add(looking).add(0.0, upward + 0.5, 0.0).add(p.getVelocity()).setDirection(d));
                }
                p.setVelocity(d.multiply(speed));
                SkillAPI.setMeta((Metadatable)p, "pmCallback", this);
                SkillAPI.setMeta((Metadatable)p, LEVEL, level);
                if (flaming) {
                    p.setFireTicks(9999);
                }
                projectiles.add(p);
            }
        }
        if (this.settings.getBool(USE_EFFECT, false)) {
            player = new EffectPlayer(this.settings);
            for (Projectile p : projectiles) {
                ((EffectPlayer)player).start(new EntityTarget((Entity)p), this.settings.getString(EFFECT_KEY, this.skill.getName()), Integer.MAX_VALUE, level, true);
            }
        }
        new RepeatingEntityTask<Projectile>(projectiles, proj -> ParticleHelper.play(proj.getLocation(), this.settings));
        new RemoveTask(projectiles, (int)this.parseValues(caster, LIFESPAN, level, 9999.0) * 20){

            @Override
            public void run() {
                super.run();
                if (ProjectileMechanic.this.settings.getBool("on-expire", false)) {
                    for (Projectile projectile1 : projectiles) {
                        ProjectileMechanic.this.callback(projectile1, null);
                    }
                }
            }
        };
        return targets.size() > 0;
    }

    public void callback(Projectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        LivingEntity finalHit = hit;
        Bukkit.getScheduler().runTaskLater((Plugin)SkillAPI.inst(), () -> {
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            targets.add(finalHit);
            this.executeChildren((LivingEntity)projectile.getShooter(), SkillAPI.getMetaInt((Metadatable)projectile, LEVEL), targets, this.skill.isForced((LivingEntity)projectile.getShooter()));
            SkillAPI.removeMeta((Metadatable)projectile, "pmCallback");
            projectile.remove();
        }, 1L);
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        final ArrayList targets = new ArrayList();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                double gravity;
                String type;
                targets.clear();
                int amount = (int)ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.AMOUNT, level, 1.0);
                String spread = ProjectileMechanic.this.settings.getString(ProjectileMechanic.SPREAD, "cone").toLowerCase();
                int lifespan = (int)(ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.LIFESPAN, level, 9999.0) * 20.0);
                double drag = switch (type = ProjectileMechanic.this.settings.getString(ProjectileMechanic.PROJECTILE, "arrow").toLowerCase()) {
                    case "egg", "snowball", "splash potion", "ender pearl", "thrown exp bottle" -> {
                        gravity = -0.03;
                        yield 0.01;
                    }
                    case "arrow", "spectral arrow", "trident" -> {
                        gravity = -0.05;
                        yield 0.01;
                    }
                    case "llama spit" -> {
                        gravity = -0.06;
                        yield 0.01;
                    }
                    case "fishing hook" -> {
                        gravity = -0.03;
                        yield 0.08;
                    }
                    default -> {
                        gravity = 0.0;
                        yield 0.0;
                    }
                };
                Settings copy = new Settings(ProjectileMechanic.this.settings);
                copy.set(ProjectileMechanic.VELOCITY, ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.VELOCITY, level, 1.0), 0.0);
                copy.set("particles", ProjectileMechanic.this.parseValues((LivingEntity)caster, "particles", level, 1.0), 0.0);
                copy.set("radius", ProjectileMechanic.this.parseValues((LivingEntity)caster, "radius", level, 0.0), 0.0);
                copy.set("gravity", gravity, 0.0);
                copy.set("drag", drag, 0.0);
                copy.set("period", ProjectileMechanic.this.preview.getInt("path-steps", 2));
                ProjectileCallback callback = (projectile, hit) -> {
                    if (hit == null) {
                        hit = new TempEntity(projectile.getLocation());
                    }
                    targets.add(hit);
                    if (ProjectileMechanic.this.preview.getBool("per-target")) {
                        ParticleHelper.play(hit.getLocation(), ProjectileMechanic.this.preview, Set.of(caster), "per-target-", ProjectileMechanic.this.preview.getBool("per-target-hitbox") ? hit.getBoundingBox() : null);
                    }
                };
                ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
                for (LivingEntity target : (List)targetSupplier.get()) {
                    Location loc = target.getLocation();
                    if (spread.equals("rain")) {
                        double radius = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.RADIUS, level, 2.0);
                        double height = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.HEIGHT, level, 8.0);
                        list.addAll(ParticleProjectile.rain((LivingEntity)caster, level, loc, copy, radius, height, amount, callback, lifespan));
                    } else {
                        Vector dir = target.getLocation().getDirection();
                        double right = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.RIGHT, level, 0.0);
                        double upward = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.UPWARD, level, 0.0);
                        double forward = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.FORWARD, level, 0.0);
                        Vector looking = dir.clone().setY(0).normalize();
                        Vector normal = looking.clone().crossProduct(UP);
                        looking.multiply(forward).add(normal.multiply(right));
                        if (spread.equals("horizontal cone")) {
                            dir.setY(0);
                            dir.normalize();
                        }
                        double angle = ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.ANGLE, level, 30.0);
                        list.addAll(ParticleProjectile.spread((LivingEntity)caster, level, dir, type.contains("arrow") ? target.getEyeLocation() : loc.add(looking).add(0.0, upward + 0.5, 0.0), copy, angle, amount, callback, lifespan));
                    }
                    for (ParticleProjectile p : list) {
                        SkillAPI.setMeta(p, ProjectileMechanic.LEVEL, level);
                        p.setAllyEnemy(true, true);
                    }
                    Consumer<Location> onStep = ProjectileMechanic.this.preview.getBool("path") ? location -> new ParticleSettings(ProjectileMechanic.this.preview, "path-").instance(caster, location.getX(), location.getY(), location.getZ()) : location -> {};
                    for (ParticleProjectile p : list) {
                        p.setOnStep(onStep);
                    }
                    for (ParticleProjectile p : list) {
                        while (p.isValid()) {
                            p.run();
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("period", 5)));
        onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        this.playChildrenPreviews(onPreviewStop, caster, level, () -> targets);
    }
}

